/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.Placeholders;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class PlaceholdersConfig
extends Config
implements Placeholders {
    public static final String NAME = "placeholders";
    private final Map<String, Collection<String>> replacements;

    public PlaceholdersConfig(String name, Map<String, Collection<String>> replacements) {
        super(name);
        this.replacements = replacements;
    }

    private Collection<String> inflate(Collection<String> input, String key, Collection<String> replacements) {
        HashSet<String> result = new HashSet<String>();
        for (String value : input) {
            for (String replacement : replacements) {
                result.add(value.replace(key, replacement));
            }
        }
        return result;
    }

    @Override
    public Collection<ResourceLocation> inflate(String str) {
        Collection<String> inputs = new HashSet<String>();
        inputs.add(str);
        for (Map.Entry<String, Collection<String>> entry : this.replacements.entrySet()) {
            inputs = this.inflate(inputs, "{" + entry.getKey() + "}", entry.getValue());
        }
        HashSet<ResourceLocation> result = new HashSet<ResourceLocation>();
        HashSet<String> invalid = new HashSet<String>();
        for (String input : inputs) {
            ResourceLocation rl = ResourceLocation.tryParse((String)input);
            if (rl == null) {
                invalid.add(input);
                continue;
            }
            result.add(rl);
        }
        if (!invalid.isEmpty()) {
            AlmostUnified.LOG.warn("The following input '{}' could not be parsed into a ResourceLocation. Reason could be missing placeholder or invalid characters. Skipping. Generated values: {}", (Object)str, invalid);
        }
        return result;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.unmodifiableCollection(this.replacements.keySet());
    }

    @Override
    public Collection<String> getValues(String key) {
        return this.replacements.getOrDefault(key, Collections.emptyList());
    }

    public static class Serializer
    extends Config.Serializer<PlaceholdersConfig> {
        @Override
        public PlaceholdersConfig deserialize(String name, JsonObject json) {
            if (json.size() == 0) {
                this.setInvalid();
                return new PlaceholdersConfig(name, Defaults.PLACEHOLDERS);
            }
            Map<String, Collection<String>> replacements = this.safeGet(() -> {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : json.entrySet()) {
                    ImmutableSet.Builder placeholders = ImmutableSet.builder();
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonPrimitive()) continue;
                        placeholders.add((Object)element.getAsString().trim());
                    }
                    builder.put((Object)((String)entry.getKey()).trim(), (Object)placeholders.build());
                }
                return builder.build();
            }, Defaults.PLACEHOLDERS);
            return new PlaceholdersConfig(name, replacements);
        }

        @Override
        public JsonObject serialize(PlaceholdersConfig src) {
            JsonObject json = new JsonObject();
            for (Map.Entry<String, Collection<String>> entry : src.replacements.entrySet()) {
                json.add(entry.getKey(), (JsonElement)JsonUtils.toArray((Iterable<String>)entry.getValue()));
            }
            return json;
        }
    }
}

