/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.api.TagInheritance;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.impl.TagInheritanceImpl;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class TagConfig
extends Config {
    public static final String NAME = "tags";
    private final Map<ResourceLocation, Set<ResourceLocation>> customTags;
    private final Map<ResourceLocation, Set<ResourceLocation>> tagOwnerships;
    private final TagInheritanceImpl.Mode itemTagInheritanceMode;
    private final Map<TagKey<Item>, Set<Pattern>> itemTagInheritance;
    private final TagInheritanceImpl.Mode blockTagInheritanceMode;
    private final Map<TagKey<Block>, Set<Pattern>> blockTagInheritance;

    public TagConfig(String name, Map<ResourceLocation, Set<ResourceLocation>> customTags, Map<ResourceLocation, Set<ResourceLocation>> tagOwnerships, TagInheritanceImpl.Mode itemTagInheritanceMode, Map<TagKey<Item>, Set<Pattern>> itemTagInheritance, TagInheritanceImpl.Mode blockTagInheritanceMode, Map<TagKey<Block>, Set<Pattern>> blockTagInheritance) {
        super(name);
        this.customTags = customTags;
        this.tagOwnerships = tagOwnerships;
        this.itemTagInheritanceMode = itemTagInheritanceMode;
        this.itemTagInheritance = itemTagInheritance;
        this.blockTagInheritanceMode = blockTagInheritanceMode;
        this.blockTagInheritance = blockTagInheritance;
    }

    public TagInheritance<Item> getItemTagInheritance() {
        return new TagInheritanceImpl<Item>(this.itemTagInheritanceMode, this.itemTagInheritance);
    }

    public TagInheritance<Block> getBlockTagInheritance() {
        return new TagInheritanceImpl<Block>(this.blockTagInheritanceMode, this.blockTagInheritance);
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getCustomTags() {
        return Collections.unmodifiableMap(this.customTags);
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getTagOwnerships() {
        return Collections.unmodifiableMap(this.tagOwnerships);
    }

    public static class Serializer
    extends Config.Serializer<TagConfig> {
        public static final String CUSTOM_TAGS = "customTags";
        public static final String TAG_OWNERSHIPS = "tagOwnerships";
        public static final String ITEM_TAG_INHERITANCE_MODE = "itemTagInheritanceMode";
        public static final String ITEM_TAG_INHERITANCE = "itemTagInheritance";
        public static final String BLOCK_TAG_INHERITANCE_MODE = "blockTagInheritanceMode";
        public static final String BLOCK_TAG_INHERITANCE = "blockTagInheritance";

        @Override
        public TagConfig deserialize(String name, JsonObject json) {
            Map customTags = this.safeGet(() -> JsonUtils.deserializeMapSet(json, CUSTOM_TAGS, e -> new ResourceLocation((String)e.getKey()), ResourceLocation::new), new HashMap());
            Map tagOwnerships = this.safeGet(() -> JsonUtils.deserializeMapSet(json, TAG_OWNERSHIPS, e -> new ResourceLocation((String)e.getKey()), ResourceLocation::new), new HashMap());
            TagInheritanceImpl.Mode itemTagInheritanceMode = this.deserializeTagInheritanceMode(json, ITEM_TAG_INHERITANCE_MODE);
            Map<TagKey<Item>, Set<Pattern>> itemTagInheritance = this.deserializePatternsForLocations(Registries.ITEM, json, ITEM_TAG_INHERITANCE);
            TagInheritanceImpl.Mode blockTagInheritanceMode = this.deserializeTagInheritanceMode(json, BLOCK_TAG_INHERITANCE_MODE);
            Map<TagKey<Block>, Set<Pattern>> blockTagInheritance = this.deserializePatternsForLocations(Registries.BLOCK, json, BLOCK_TAG_INHERITANCE);
            return new TagConfig(name, customTags, tagOwnerships, itemTagInheritanceMode, itemTagInheritance, blockTagInheritanceMode, blockTagInheritance);
        }

        @Override
        public JsonObject serialize(TagConfig config) {
            JsonObject json = new JsonObject();
            JsonObject customTags = new JsonObject();
            config.customTags.forEach((parent, child) -> customTags.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(ResourceLocation::toString).toList())));
            json.add(CUSTOM_TAGS, (JsonElement)customTags);
            JsonObject tagOwnerships = new JsonObject();
            config.tagOwnerships.forEach((parent, child) -> tagOwnerships.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(ResourceLocation::toString).toList())));
            json.add(TAG_OWNERSHIPS, (JsonElement)tagOwnerships);
            JsonObject itemTagInheritance = new JsonObject();
            config.itemTagInheritance.forEach((tag, patterns) -> itemTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(ITEM_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.itemTagInheritanceMode.toString()));
            json.add(ITEM_TAG_INHERITANCE, (JsonElement)itemTagInheritance);
            JsonObject blockTagInheritance = new JsonObject();
            config.blockTagInheritance.forEach((tag, patterns) -> blockTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(BLOCK_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.blockTagInheritanceMode.toString()));
            json.add(BLOCK_TAG_INHERITANCE, (JsonElement)blockTagInheritance);
            return json;
        }

        private <T> Map<TagKey<T>, Set<Pattern>> unsafeDeserializePatternsForLocations(ResourceKey<Registry<T>> registry, JsonObject rawConfigJson, String baseKey) {
            return JsonUtils.deserializeMapSet(rawConfigJson, baseKey, e -> TagKey.create((ResourceKey)registry, (ResourceLocation)new ResourceLocation((String)e.getKey())), Pattern::compile);
        }

        private <T> Map<TagKey<T>, Set<Pattern>> deserializePatternsForLocations(ResourceKey<Registry<T>> registry, JsonObject rawConfigJson, String baseKey) {
            return this.safeGet(() -> this.unsafeDeserializePatternsForLocations(registry, rawConfigJson, baseKey), new HashMap());
        }

        private TagInheritanceImpl.Mode deserializeTagInheritanceMode(JsonObject json, String key) {
            return this.safeGet(() -> TagInheritanceImpl.Mode.valueOf(json.getAsJsonPrimitive(key).getAsString().toUpperCase()), TagInheritanceImpl.Mode.ALLOW);
        }
    }
}

