/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.api.ModPriorities;
import com.almostreliable.unified.api.Placeholders;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.recipe.ModPrioritiesImpl;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class UnifyConfig
extends Config {
    private final List<String> modPriorities;
    private final Map<TagKey<Item>, String> priorityOverrides;
    private final List<String> stoneStrata;
    private final List<String> unbakedTags;
    private final Set<TagKey<Item>> ignoredTags;
    private final Set<Pattern> ignoredItems;
    private final Set<Pattern> ignoredRecipeTypes;
    private final Set<Pattern> ignoredRecipes;
    private final boolean recipeViewerHiding;
    @Nullable
    private Set<TagKey<Item>> bakedTagsCache;

    public static Collection<UnifyConfig> safeLoadConfigs() {
        try {
            return UnifyConfig.loadConfigs();
        }
        catch (IOException e) {
            AlmostUnified.LOG.error("Could not load configs", (Throwable)e);
            return List.of();
        }
    }

    public static Collection<UnifyConfig> loadConfigs() throws IOException {
        Path unifyFolder = AlmostUnifiedPlatform.INSTANCE.getConfigPath().resolve("unify");
        Map<String, JsonObject> jsons = UnifyConfig.readJsons(unifyFolder);
        if (jsons.isEmpty()) {
            Serializer serializer = new Serializer();
            UnifyConfig defaultConfig = serializer.deserialize("materials", new JsonObject());
            Config.save(unifyFolder.resolve("materials.json"), defaultConfig, serializer);
            return List.of(defaultConfig);
        }
        ArrayList<UnifyConfig> configs = new ArrayList<UnifyConfig>();
        for (Map.Entry<String, JsonObject> entry : jsons.entrySet()) {
            String name = entry.getKey();
            JsonObject json = entry.getValue();
            Serializer serializer = new Serializer();
            UnifyConfig config = serializer.deserialize(name, json);
            if (serializer.isInvalid()) {
                AlmostUnified.LOG.warn("Unify config not found or invalid. Creating new config: {}", (Object)name);
                UnifyConfig.save(unifyFolder.resolve(config.getName() + ".json"), config, serializer);
            }
            configs.add(config);
        }
        return configs;
    }

    public static Map<String, JsonObject> readJsons(Path directory) {
        HashMap<String, JsonObject> result = new HashMap<String, JsonObject>();
        Gson gson = new Gson();
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            Collection files = FileUtils.listFiles((File)directory.toFile(), (String[])new String[]{"json"}, (boolean)false);
            for (File file : files) {
                String fileName = FilenameUtils.getBaseName((String)file.getName());
                try {
                    String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    JsonObject jsonObject = (JsonObject)gson.fromJson(content, JsonObject.class);
                    result.put(fileName, jsonObject);
                }
                catch (Throwable e) {
                    AlmostUnified.LOG.error("Could not load json from file {}.json: ", (Object)fileName, (Object)e);
                }
            }
        }
        catch (Throwable e) {
            AlmostUnified.LOG.error("Could not load jsons: ", e);
        }
        return result;
    }

    public UnifyConfig(String name, List<String> modPriorities, Map<TagKey<Item>, String> priorityOverrides, List<String> stoneStrata, List<String> unbakedTags, Set<TagKey<Item>> ignoredTags, Set<Pattern> ignoredItems, Set<Pattern> ignoredRecipeTypes, Set<Pattern> ignoredRecipes, boolean recipeViewerHiding) {
        super(name);
        this.modPriorities = modPriorities;
        this.priorityOverrides = priorityOverrides;
        this.stoneStrata = stoneStrata;
        this.unbakedTags = unbakedTags;
        this.ignoredTags = ignoredTags;
        this.ignoredItems = ignoredItems;
        this.ignoredRecipeTypes = ignoredRecipeTypes;
        this.ignoredRecipes = ignoredRecipes;
        this.recipeViewerHiding = recipeViewerHiding;
    }

    public ModPriorities getModPriorities() {
        return new ModPrioritiesImpl(this.modPriorities, this.priorityOverrides);
    }

    public List<String> getStoneStrata() {
        return this.stoneStrata;
    }

    public Set<TagKey<Item>> getBakedTags() {
        if (this.bakedTagsCache == null) {
            throw new IllegalStateException("Tags are not baked. bakeTags(...) must be called first");
        }
        return this.bakedTagsCache;
    }

    public Set<TagKey<Item>> bakeTags(Predicate<TagKey<Item>> tagValidator, Placeholders placeholders) {
        if (this.bakedTagsCache != null) {
            return this.bakedTagsCache;
        }
        HashSet<TagKey<Item>> result = new HashSet<TagKey<Item>>();
        for (String unbakedTag : this.unbakedTags) {
            Collection<ResourceLocation> inflate = placeholders.inflate(unbakedTag);
            for (ResourceLocation rl : inflate) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl);
                if (this.ignoredTags.contains(tag) || result.contains(tag) || !tagValidator.test((TagKey<Item>)tag)) continue;
                result.add((TagKey<Item>)tag);
            }
        }
        this.bakedTagsCache = result;
        return result;
    }

    public boolean includeItem(ResourceLocation item) {
        for (Pattern pattern : this.ignoredItems) {
            if (!pattern.matcher(item.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public Set<Pattern> getIgnoredRecipeTypes() {
        return this.ignoredRecipeTypes;
    }

    public Set<Pattern> getIgnoredRecipes() {
        return this.ignoredRecipes;
    }

    public boolean hideNonPreferredItemsInRecipeViewers() {
        return this.recipeViewerHiding;
    }

    public static class Serializer
    extends Config.Serializer<UnifyConfig> {
        public static final String MOD_PRIORITIES = "modPriorities";
        public static final String STONE_STRATA = "stoneStrata";
        public static final String TAGS = "tags";
        public static final String MATERIALS = "materials";
        public static final String PRIORITY_OVERRIDES = "priorityOverrides";
        public static final String IGNORED_TAGS = "ignoredTags";
        public static final String IGNORED_ITEMS = "ignoredItems";
        public static final String IGNORED_RECIPE_TYPES = "ignoredRecipeTypes";
        public static final String IGNORED_RECIPES = "ignoredRecipes";
        public static final String RECIPE_VIEWER_HIDING = "recipeViewerHiding";

        @Override
        public UnifyConfig deserialize(String name, JsonObject json) {
            AlmostUnifiedPlatform.Platform platform = AlmostUnifiedPlatform.INSTANCE.getPlatform();
            List<String> modPriorities = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MOD_PRIORITIES)), Defaults.getModPriorities(platform));
            Map priorityOverrides = this.safeGet(() -> JsonUtils.deserializeMap(json, PRIORITY_OVERRIDES, e -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation((String)e.getKey())), e -> ((JsonElement)e.getValue()).getAsString()), new HashMap());
            List<String> stoneStrata = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(STONE_STRATA)), Defaults.STONE_STRATA);
            List<String> tags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(TAGS)), Defaults.getTags(platform));
            Set ignoredTags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(IGNORED_TAGS)).stream().map(s -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toSet()), new HashSet());
            Set<Pattern> ignoredItems = this.deserializePatterns(json, IGNORED_ITEMS, List.of());
            Set<Pattern> ignoredRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.getIgnoredRecipeTypes(platform));
            Set<Pattern> ignoredRecipes = this.deserializePatterns(json, IGNORED_RECIPES, List.of());
            boolean recipeViewerHiding = this.safeGet(() -> json.getAsJsonPrimitive(RECIPE_VIEWER_HIDING).getAsBoolean(), true);
            return new UnifyConfig(name, modPriorities, priorityOverrides, stoneStrata, tags, ignoredTags, ignoredItems, ignoredRecipeTypes, ignoredRecipes, recipeViewerHiding);
        }

        @Override
        public JsonObject serialize(UnifyConfig config) {
            JsonObject json = new JsonObject();
            json.add(MOD_PRIORITIES, (JsonElement)JsonUtils.toArray(config.modPriorities));
            json.add(STONE_STRATA, (JsonElement)JsonUtils.toArray(config.stoneStrata));
            json.add(TAGS, (JsonElement)JsonUtils.toArray(config.unbakedTags));
            JsonObject priorityOverrides = new JsonObject();
            config.priorityOverrides.forEach((tag, mod) -> priorityOverrides.addProperty(tag.location().toString(), mod));
            json.add(PRIORITY_OVERRIDES, (JsonElement)priorityOverrides);
            json.add(IGNORED_TAGS, (JsonElement)JsonUtils.toArray(config.ignoredTags.stream().map(TagKey::location).map(ResourceLocation::toString).toList()));
            this.serializePatterns(json, IGNORED_ITEMS, config.ignoredItems);
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoredRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPES, config.ignoredRecipes);
            json.addProperty(RECIPE_VIEWER_HIDING, Boolean.valueOf(config.recipeViewerHiding));
            return json;
        }
    }
}

