/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.TagMap;
import com.almostreliable.unified.api.TagOwnerships;
import com.almostreliable.unified.api.UnifierRegistry;
import com.almostreliable.unified.api.UnifyHandler;
import com.almostreliable.unified.api.UnifyLookup;
import com.almostreliable.unified.config.DebugConfig;
import com.almostreliable.unified.config.DuplicationConfig;
import com.almostreliable.unified.impl.CompositeUnifyLookup;
import com.almostreliable.unified.recipe.RecipeDumper;
import com.almostreliable.unified.recipe.RecipeTransformer;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class AlmostUnifiedRuntimeImpl
implements AlmostUnifiedRuntime {
    private final TagMap<Item> tagMap;
    private final Collection<? extends UnifyHandler> unifyHandlers;
    private final DuplicationConfig duplicationConfig;
    private final DebugConfig debugConfig;
    private final UnifierRegistry unifierRegistry;
    private final TagOwnerships tagOwnerships;
    private final UnifyLookup compositeUnifyLookup;

    public AlmostUnifiedRuntimeImpl(TagMap<Item> tagMap, Collection<? extends UnifyHandler> unifyHandlers, DuplicationConfig duplicationConfig, DebugConfig debugConfig, UnifierRegistry unifierRegistry, TagOwnerships tagOwnerships) {
        this.tagMap = tagMap;
        this.unifyHandlers = unifyHandlers;
        this.duplicationConfig = duplicationConfig;
        this.debugConfig = debugConfig;
        this.unifierRegistry = unifierRegistry;
        this.tagOwnerships = tagOwnerships;
        this.compositeUnifyLookup = new CompositeUnifyLookup(unifyHandlers, tagOwnerships);
    }

    @Override
    public void run(Map<ResourceLocation, JsonElement> recipes, boolean skipClientTracking) {
        this.debugConfig.logRecipes(recipes, "recipes_before_unification.txt");
        this.debugConfig.logUnifyTagDump(this.tagMap);
        long startTime = System.currentTimeMillis();
        RecipeTransformer.Result result = new RecipeTransformer(this.unifierRegistry, this.unifyHandlers, this.duplicationConfig).transformRecipes(recipes, skipClientTracking);
        RecipeDumper dumper = new RecipeDumper(result, startTime, System.currentTimeMillis());
        dumper.dump(this.debugConfig.dumpOverview, this.debugConfig.dumpUnification, this.debugConfig.dumpDuplicates);
        this.debugConfig.logRecipes(recipes, "recipes_after_unification.txt");
    }

    @Override
    public TagMap<Item> getTagMap() {
        return this.tagMap;
    }

    @Override
    public UnifyLookup getUnifyLookup() {
        return this.compositeUnifyLookup;
    }

    @Override
    public Collection<? extends UnifyHandler> getUnifyHandlers() {
        return Collections.unmodifiableCollection(this.unifyHandlers);
    }

    @Override
    @Nullable
    public UnifyHandler getUnifyHandler(String name) {
        for (UnifyHandler unifyHandler : this.unifyHandlers) {
            if (!unifyHandler.getName().equals(name)) continue;
            return unifyHandler;
        }
        return null;
    }

    @Override
    public TagOwnerships getTagOwnerships() {
        return this.tagOwnerships;
    }
}

