/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.api.StoneStrataLookup;
import com.almostreliable.unified.api.TagMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public final class StoneStrataLookupImpl
implements StoneStrataLookup {
    private final List<String> stoneStrata;
    private final Pattern tagMatcher;
    private final TagMap<Item> stoneStrataTagMap;
    private final Map<TagKey<Item>, Boolean> stoneStrataTagCache;
    private final Map<ResourceLocation, String> stoneStrataCache;

    private StoneStrataLookupImpl(Collection<String> stoneStrata, Pattern tagMatcher, TagMap<Item> stoneStrataTagMap) {
        this.stoneStrata = StoneStrataLookupImpl.createSortedStoneStrata(stoneStrata);
        this.tagMatcher = tagMatcher;
        this.stoneStrataTagMap = stoneStrataTagMap;
        this.stoneStrataTagCache = new HashMap<TagKey<Item>, Boolean>();
        this.stoneStrataCache = new HashMap<ResourceLocation, String>();
    }

    private static List<String> createSortedStoneStrata(Collection<String> stoneStrata) {
        return stoneStrata.stream().sorted(Comparator.comparingInt(String::length).reversed()).toList();
    }

    public static StoneStrataLookup create(Collection<String> stoneStrataIds, TagMap<Item> tagMap) {
        Set<TagKey<Item>> stoneStrataTags = AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(stoneStrataIds);
        TagMap<Item> stoneStrataTagMap = tagMap.filtered(stoneStrataTags::contains, item -> true);
        Pattern tagMatcher = Pattern.compile(switch (AlmostUnifiedPlatform.INSTANCE.getPlatform()) {
            default -> throw new IncompatibleClassChangeError();
            case AlmostUnifiedPlatform.Platform.FORGE -> "forge:ores/.+";
            case AlmostUnifiedPlatform.Platform.FABRIC -> "(c:ores/.+|c:.+_ores)";
        });
        return new StoneStrataLookupImpl(stoneStrataIds, tagMatcher, stoneStrataTagMap);
    }

    @Override
    public String getStoneStrata(ResourceLocation item) {
        return this.stoneStrataCache.computeIfAbsent(item, this::computeStoneStrata);
    }

    private String computeStoneStrata(ResourceLocation item) {
        String strata = this.stoneStrataTagMap.getTagsByEntry(item).stream().findFirst().map(TagKey::location).map(ResourceLocation::toString).map(s -> {
            int i = s.lastIndexOf(47);
            return i == -1 ? null : s.substring(i + 1);
        }).orElse(null);
        if (strata != null) {
            if (strata.equals("stone")) {
                return "";
            }
            return strata;
        }
        for (String stone : this.stoneStrata) {
            if (!item.getPath().contains(stone + "_")) continue;
            if (stone.equals("stone")) {
                return "";
            }
            return stone;
        }
        return "";
    }

    @Override
    public boolean isStoneStrataTag(TagKey<Item> tag) {
        return this.stoneStrataTagCache.computeIfAbsent(tag, t -> this.tagMatcher.matcher(t.location().toString()).matches());
    }
}

