/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.api.TagInheritance;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class TagInheritanceImpl<T>
implements TagInheritance<T> {
    private final Mode mode;
    private final Map<TagKey<T>, Set<Pattern>> inheritance;

    public TagInheritanceImpl(Mode mode, Map<TagKey<T>, Set<Pattern>> inheritance) {
        this.mode = mode;
        this.inheritance = inheritance;
    }

    @Override
    public boolean shouldInherit(TagKey<T> tag, Collection<TagKey<Item>> tags) {
        Set<Pattern> patterns = this.inheritance.getOrDefault(tag, Set.of());
        boolean result = this.checkPatterns(tags, patterns);
        return this.mode == Mode.ALLOW ? result : !result;
    }

    private boolean checkPatterns(Collection<TagKey<Item>> tags, Collection<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            for (TagKey<Item> tag : tags) {
                if (!pattern.matcher(tag.location().toString()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Mode {
        ALLOW,
        DENY;

    }
}

