/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.api.TagMap;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class TagMapImpl<T>
implements TagMap<T> {
    private final Map<TagKey<T>, Set<ResourceLocation>> tagsToEntries = new HashMap<TagKey<T>, Set<ResourceLocation>>();
    private final Map<ResourceLocation, Set<TagKey<T>>> entriesToTags = new HashMap<ResourceLocation, Set<TagKey<T>>>();

    @VisibleForTesting
    public TagMapImpl() {
    }

    public static TagMap<Item> create(Set<TagKey<Item>> tags) {
        TagMapImpl<Item> tagMap = new TagMapImpl<Item>();
        tags.forEach(tag -> BuiltInRegistries.ITEM.getTagOrEmpty(tag).forEach(holder -> {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)((Item)holder.value()));
            tagMap.put((TagKey<Item>)tag, key);
        }));
        return tagMap;
    }

    public static TagMap<Item> createFromItemTags(Map<ResourceLocation, Collection<Holder<Item>>> tags) {
        TagMapImpl<Item> tagMap = new TagMapImpl<Item>();
        for (Map.Entry<ResourceLocation, Collection<Holder<Item>>> entry : tags.entrySet()) {
            TagKey unifyTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)entry.getKey());
            TagMapImpl.fillEntries(tagMap, entry.getValue(), unifyTag, BuiltInRegistries.ITEM);
        }
        return tagMap;
    }

    public static TagMap<Block> createFromBlockTags(Map<ResourceLocation, Collection<Holder<Block>>> tags) {
        TagMapImpl<Block> tagMap = new TagMapImpl<Block>();
        for (Map.Entry<ResourceLocation, Collection<Holder<Block>>> entry : tags.entrySet()) {
            TagKey unifyTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)entry.getKey());
            TagMapImpl.fillEntries(tagMap, entry.getValue(), unifyTag, BuiltInRegistries.BLOCK);
        }
        return tagMap;
    }

    private static <T> void fillEntries(TagMapImpl<T> tagMap, Collection<Holder<T>> holders, TagKey<T> unifyTag, Registry<T> registry) {
        for (Holder<T> holder : holders) {
            holder.unwrapKey().map(ResourceKey::location).filter(arg_0 -> registry.containsKey(arg_0)).ifPresent(id -> tagMap.put(unifyTag, (ResourceLocation)id));
        }
    }

    public static <T> TagMap<T> compose(List<TagMap<T>> tagMaps) {
        TagMapImpl<T> result = new TagMapImpl<T>();
        for (TagMap<T> tagMap : tagMaps) {
            Set<TagKey<T>> tags = tagMap.getTags();
            for (TagKey<T> tag : tags) {
                if (!result.getEntriesByTag(tag).isEmpty()) {
                    throw new IllegalArgumentException("Tag map already contains entries for " + tag);
                }
                for (ResourceLocation rl : tagMap.getEntriesByTag(tag)) {
                    result.put(tag, rl);
                }
            }
        }
        return result;
    }

    @Override
    public TagMap<T> filtered(Predicate<TagKey<T>> tagFilter, Predicate<ResourceLocation> entryFilter) {
        TagMapImpl tagMap = new TagMapImpl();
        this.tagsToEntries.forEach((tag, items) -> {
            if (!tagFilter.test((TagKey)tag)) {
                return;
            }
            items.stream().filter(entryFilter).forEach(item -> tagMap.put((TagKey)tag, (ResourceLocation)item));
        });
        return tagMap;
    }

    @Override
    public int tagSize() {
        return this.tagsToEntries.size();
    }

    @Override
    public int itemSize() {
        return this.entriesToTags.size();
    }

    @Override
    public Set<ResourceLocation> getEntriesByTag(TagKey<T> tag) {
        return Collections.unmodifiableSet(this.tagsToEntries.getOrDefault(tag, Collections.emptySet()));
    }

    @Override
    public Set<TagKey<T>> getTagsByEntry(ResourceLocation entry) {
        return Collections.unmodifiableSet(this.entriesToTags.getOrDefault(entry, Collections.emptySet()));
    }

    @Override
    public Set<TagKey<T>> getTags() {
        return Collections.unmodifiableSet(this.tagsToEntries.keySet());
    }

    private void put(TagKey<T> tag, ResourceLocation ... entries) {
        Set entriesForTag = this.tagsToEntries.computeIfAbsent(tag, k -> new HashSet());
        for (ResourceLocation entry : entries) {
            entriesForTag.add(entry);
            this.entriesToTags.computeIfAbsent(entry, k -> new HashSet()).add(tag);
        }
    }

    public static class Builder<T> {
        private final TagMapImpl<T> tagMap = new TagMapImpl();

        public Builder<T> put(TagKey<T> tag, ResourceLocation ... entries) {
            for (ResourceLocation entry : entries) {
                this.tagMap.put(tag, entry);
            }
            return this;
        }

        public Builder<T> put(TagKey<T> tag, String ... entries) {
            for (String entry : entries) {
                this.tagMap.put(tag, new ResourceLocation(entry));
            }
            return this;
        }

        public Builder<T> put(TagKey<T> tag, Item ... entries) {
            for (Item entry : entries) {
                ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)entry);
                if (key.equals((Object)BuiltInRegistries.ITEM.getDefaultKey())) {
                    throw new IllegalStateException("Cannot put item " + entry + " in tag " + tag);
                }
                this.tagMap.put(tag, key);
            }
            return this;
        }

        public TagMap<T> build() {
            return this.tagMap;
        }
    }
}

