/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.TagOwnerships;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class TagOwnershipsImpl
implements TagOwnerships {
    private final Map<TagKey<Item>, TagKey<Item>> refsToOwner;
    private final Multimap<TagKey<Item>, TagKey<Item>> ownerToRefs;

    public TagOwnershipsImpl(Predicate<TagKey<Item>> enabledTagsFilter, Map<ResourceLocation, Set<ResourceLocation>> rawTagOwnerships) {
        ImmutableMap.Builder refsToOwnerBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder ownerToRefsBuilder = ImmutableMultimap.builder();
        rawTagOwnerships.forEach((rawOwner, rawRefs) -> {
            for (ResourceLocation rawRef : rawRefs) {
                TagKey owner = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rawOwner);
                TagKey ref = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rawRef);
                if (!enabledTagsFilter.test(owner)) {
                    AlmostUnified.LOG.warn("[TagOwnerships] Owner tag '#{}' is not present in the unify tag list!", (Object)owner.location());
                    continue;
                }
                if (enabledTagsFilter.test(ref)) {
                    AlmostUnified.LOG.warn("[TagOwnerships] Reference tag '#{}' of owner tag '#{}' is present in the unify tag list!", (Object)ref.location(), (Object)owner.location());
                    continue;
                }
                refsToOwnerBuilder.put((Object)ref, (Object)owner);
                ownerToRefsBuilder.put((Object)owner, (Object)ref);
            }
        });
        this.refsToOwner = refsToOwnerBuilder.build();
        this.ownerToRefs = ownerToRefsBuilder.build();
    }

    public TagOwnershipsImpl() {
        this(t -> false, Collections.emptyMap());
    }

    public void applyOwnerships(Map<ResourceLocation, Collection<Holder<Item>>> rawTags) {
        HashMultimap changedTags = HashMultimap.create();
        this.ownerToRefs.asMap().forEach((arg_0, arg_1) -> TagOwnershipsImpl.lambda$applyOwnerships$3(rawTags, (Multimap)changedTags, arg_0, arg_1));
        if (!changedTags.isEmpty()) {
            changedTags.asMap().forEach((tag, items) -> AlmostUnified.LOG.info("[TagOwnerships] Modified tag '#{}', added {}", tag, items));
        }
    }

    @Override
    @Nullable
    public TagKey<Item> getOwner(TagKey<Item> referenceTag) {
        return this.refsToOwner.get(referenceTag);
    }

    @Override
    public Collection<TagKey<Item>> getRefs(TagKey<Item> ownerTag) {
        return Collections.unmodifiableCollection(this.ownerToRefs.get(ownerTag));
    }

    @Override
    public Set<TagKey<Item>> getRefs() {
        return this.refsToOwner.keySet();
    }

    private static /* synthetic */ void lambda$applyOwnerships$3(Map rawTags, Multimap changedTags, TagKey owner, Collection refs) {
        Collection rawHolders = (Collection)rawTags.get(owner.location());
        if (rawHolders == null) {
            AlmostUnified.LOG.warn("[TagOwnerships] Owner tag '#{}' does not exist!", (Object)owner.location());
            return;
        }
        ImmutableSet.Builder holders = ImmutableSet.builder();
        holders.addAll((Iterable)rawHolders);
        boolean changed = false;
        for (TagKey ref : refs) {
            Collection refHolders = (Collection)rawTags.get(ref.location());
            if (refHolders == null) {
                AlmostUnified.LOG.warn("[TagOwnerships] Reference tag '#{}' of owner tag '#{}' does not exist!", (Object)ref.location(), (Object)owner.location());
                continue;
            }
            for (Holder holder : refHolders) {
                holders.add((Object)holder);
                holder.unwrapKey().ifPresent(key -> changedTags.put((Object)owner.location(), (Object)key.location()));
                changed = true;
            }
        }
        if (changed) {
            rawTags.put(owner.location(), holders.build());
        }
    }
}

