/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.api.ModPriorities;
import com.almostreliable.unified.api.StoneStrataLookup;
import com.almostreliable.unified.api.TagMap;
import com.almostreliable.unified.api.TagOwnerships;
import com.almostreliable.unified.api.UnifyHandler;
import com.almostreliable.unified.api.UnifyLookup;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.impl.StoneStrataLookupImpl;
import com.almostreliable.unified.impl.TagOwnershipsImpl;
import com.almostreliable.unified.impl.UnifyLookupImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class UnifyHandlerImpl
implements UnifyHandler {
    private final ModPriorities modPriorities;
    private final UnifyLookup unifyLookup;
    private final boolean recipeViewerHiding;
    private final TagMap<Item> tagMap;
    private final Set<Pattern> ignoredRecipes;
    private final Set<Pattern> ignoredRecipeTypes;
    private final Map<ResourceLocation, Boolean> ignoredRecipeTypesCache = new HashMap<ResourceLocation, Boolean>();
    private final String name;

    public static List<UnifyHandler> create(Collection<UnifyConfig> configs, TagMap<Item> tags, TagOwnershipsImpl tagOwnerships) {
        return configs.stream().map(uc -> UnifyHandlerImpl.create(tags, uc, (TagOwnerships)tagOwnerships)).toList();
    }

    public static UnifyHandler create(TagMap<Item> globalTagMap, UnifyConfig config, TagOwnerships tagOwnerships) {
        Set<TagKey<Item>> unifyTags = config.getBakedTags();
        TagMap<Item> filteredTagMap = globalTagMap.filtered(unifyTags::contains, config::includeItem);
        StoneStrataLookup stoneStrata = StoneStrataLookupImpl.create(config.getStoneStrata(), globalTagMap);
        return new UnifyHandlerImpl(config.getName(), config.getModPriorities(), stoneStrata, tagOwnerships, filteredTagMap, config.getIgnoredRecipes(), config.getIgnoredRecipeTypes(), config.hideNonPreferredItemsInRecipeViewers());
    }

    public UnifyHandlerImpl(String name, ModPriorities modPriorities, StoneStrataLookup stoneStrata, TagOwnerships tagOwnerships, TagMap<Item> tagMap, Set<Pattern> ignoredRecipes, Set<Pattern> ignoredRecipeTypes, boolean recipeViewerHiding) {
        this.name = name;
        this.modPriorities = modPriorities;
        this.tagMap = tagMap;
        this.ignoredRecipes = ignoredRecipes;
        this.ignoredRecipeTypes = ignoredRecipeTypes;
        this.unifyLookup = new UnifyLookupImpl(modPriorities, tagMap, stoneStrata, tagOwnerships);
        this.recipeViewerHiding = recipeViewerHiding;
    }

    @Override
    public ModPriorities getModPriorities() {
        return this.modPriorities;
    }

    @Override
    public boolean shouldIncludeRecipeId(ResourceLocation id) {
        for (Pattern pattern : this.ignoredRecipes) {
            if (!pattern.matcher(id.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldIncludeRecipeType(ResourceLocation type) {
        return this.ignoredRecipeTypesCache.computeIfAbsent(type, t -> {
            for (Pattern pattern : this.ignoredRecipeTypes) {
                if (!pattern.matcher(t.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public void clearCache() {
        this.ignoredRecipeTypesCache.clear();
    }

    @Override
    public TagMap<Item> getTagMap() {
        return this.tagMap;
    }

    @Override
    public boolean hideNonPreferredItemsInRecipeViewers() {
        return this.recipeViewerHiding;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public TagKey<Item> getPreferredTagForItem(ResourceLocation item) {
        return this.unifyLookup.getPreferredTagForItem(item);
    }

    @Override
    @Nullable
    public ResourceLocation getReplacementForItem(ResourceLocation item) {
        return this.unifyLookup.getReplacementForItem(item);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(TagKey<Item> tag) {
        return this.unifyLookup.getPreferredItemForTag(tag);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(TagKey<Item> tag, Predicate<ResourceLocation> itemFilter) {
        return this.unifyLookup.getPreferredItemForTag(tag, itemFilter);
    }

    @Override
    public boolean isItemInUnifiedIngredient(Ingredient ingred, ItemStack item) {
        return this.unifyLookup.isItemInUnifiedIngredient(ingred, item);
    }

    @Override
    public TagOwnerships getTagOwnerships() {
        return this.unifyLookup.getTagOwnerships();
    }
}

