/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.impl;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.ModPriorities;
import com.almostreliable.unified.api.StoneStrataLookup;
import com.almostreliable.unified.api.TagMap;
import com.almostreliable.unified.api.TagOwnerships;
import com.almostreliable.unified.api.UnifyLookup;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class UnifyLookupImpl
implements UnifyLookup {
    private final ModPriorities modPriorities;
    private final TagMap<Item> tagMap;
    private final StoneStrataLookup stoneStrataLookup;
    private final TagOwnerships tagOwnerships;
    private final Set<ResourceLocation> warnings;

    public UnifyLookupImpl(ModPriorities modPriorities, TagMap<Item> tagMap, StoneStrataLookup stoneStrataLookup, TagOwnerships tagOwnerships) {
        this.tagMap = tagMap;
        this.modPriorities = modPriorities;
        this.stoneStrataLookup = stoneStrataLookup;
        this.tagOwnerships = tagOwnerships;
        this.warnings = new HashSet<ResourceLocation>();
    }

    @Override
    @Nullable
    public TagKey<Item> getPreferredTagForItem(ResourceLocation item) {
        Set<TagKey<Item>> tags = this.tagMap.getTagsByEntry(item);
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1 && !this.warnings.contains(item)) {
            AlmostUnified.LOG.warn("Item '{}' has multiple preferred tags '{}' for recipe replacement. This needs to be manually fixed by the user.", (Object)item, tags.stream().map(TagKey::location).toList());
            this.warnings.add(item);
        }
        return tags.iterator().next();
    }

    @Override
    @Nullable
    public ResourceLocation getReplacementForItem(ResourceLocation item) {
        TagKey<Item> t = this.getPreferredTagForItem(item);
        if (t == null) {
            return null;
        }
        if (this.stoneStrataLookup.isStoneStrataTag(t)) {
            String stone = this.stoneStrataLookup.getStoneStrata(item);
            return this.getPreferredItemForTag(t, i -> stone.equals(this.stoneStrataLookup.getStoneStrata((ResourceLocation)i)));
        }
        return this.getPreferredItemForTag(t);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(TagKey<Item> tag) {
        return this.getPreferredItemForTag(tag, i -> true);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(TagKey<Item> tag, Predicate<ResourceLocation> itemFilter) {
        List<ResourceLocation> items;
        TagKey<Item> tagToLookup = this.tagOwnerships.getOwner(tag);
        if (tagToLookup == null) {
            tagToLookup = tag;
        }
        if ((items = this.tagMap.getEntriesByTag(tagToLookup).stream().filter(itemFilter).sorted(Comparator.comparingInt(value -> value.toString().length())).toList()).isEmpty()) {
            return null;
        }
        return this.modPriorities.findPreferredItemId(tagToLookup, items);
    }

    @Override
    public boolean isItemInUnifiedIngredient(Ingredient ingred, ItemStack item) {
        HashSet<TagKey<Item>> checkedTags = new HashSet<TagKey<Item>>();
        for (ItemStack ingredItem : ingred.getItems()) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)ingredItem.getItem());
            TagKey<Item> preferredTag = this.getPreferredTagForItem(itemId);
            if (preferredTag == null || checkedTags.contains(preferredTag)) continue;
            checkedTags.add(preferredTag);
            if (!item.is(preferredTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TagOwnerships getTagOwnerships() {
        return this.tagOwnerships;
    }
}

