/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.ModPriorities;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public record ModPrioritiesImpl(List<String> modPriorities, Map<TagKey<Item>, String> priorityOverrides) implements ModPriorities
{
    @Override
    @Nullable
    public String getPriorityOverride(TagKey<Item> tag) {
        return this.priorityOverrides.get(tag);
    }

    @Override
    @Nullable
    public ResourceLocation findPreferredItemId(TagKey<Item> tag, List<ResourceLocation> items) {
        ResourceLocation overrideItem = this.getOverrideForTag(tag, items);
        if (overrideItem != null) {
            return overrideItem;
        }
        for (String modPriority : this) {
            ResourceLocation item = this.findItemByNamespace(items, modPriority);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Nullable
    private ResourceLocation getOverrideForTag(TagKey<Item> tag, List<ResourceLocation> items) {
        String priorityOverride = this.getPriorityOverride(tag);
        if (priorityOverride != null) {
            ResourceLocation item = this.findItemByNamespace(items, priorityOverride);
            if (item != null) {
                return item;
            }
            AlmostUnified.LOG.warn("Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.", (Object)priorityOverride, (Object)tag.location());
        }
        return null;
    }

    @Nullable
    private ResourceLocation findItemByNamespace(List<ResourceLocation> items, String namespace) {
        for (ResourceLocation item : items) {
            if (!item.getNamespace().equals(namespace)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return this.modPriorities.iterator();
    }

    @Override
    public void forEachOverride(BiConsumer<TagKey<Item>, String> callback) {
        this.priorityOverrides().forEach(callback);
    }
}

