/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.api.UnifyLookup;
import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeJson;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class RecipeContextImpl
implements RecipeContext {
    private final List<String> defaultInputDepthLookups = List.of("value", "base", "ingredient");
    private final UnifyLookup unifyLookup;

    public RecipeContextImpl(UnifyLookup unifyLookup) {
        this.unifyLookup = unifyLookup;
    }

    @Override
    @Nullable
    public ResourceLocation getReplacementForItem(@Nullable ResourceLocation item) {
        if (item == null) {
            return null;
        }
        return this.unifyLookup.getReplacementForItem(item);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return null;
        }
        return this.unifyLookup.getPreferredItemForTag(tag);
    }

    @Override
    @Nullable
    public TagKey<Item> getPreferredTagForItem(@Nullable ResourceLocation item) {
        if (item == null) {
            return null;
        }
        return this.unifyLookup.getPreferredTagForItem(item);
    }

    @Override
    @Nullable
    public JsonElement createIngredientReplacement(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        this.tryCreateIngredientReplacement(copy);
        return element.equals(copy) ? null : copy;
    }

    private void tryCreateIngredientReplacement(@Nullable JsonElement element) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            for (JsonElement e : array) {
                this.tryCreateIngredientReplacement(e);
            }
        }
        if (element instanceof JsonObject) {
            ResourceLocation item;
            TagKey<Item> tag;
            TagKey<Item> tag2;
            JsonPrimitive primitive;
            JsonElement e;
            JsonObject object = (JsonObject)element;
            this.tryCreateIngredientReplacement(object.get("value"));
            this.tryCreateIngredientReplacement(object.get("base"));
            this.tryCreateIngredientReplacement(object.get("ingredient"));
            e = object.get("tag");
            if (e instanceof JsonPrimitive) {
                primitive = (JsonPrimitive)e;
                tag2 = Utils.toItemTag(primitive.getAsString());
                TagKey<Item> ownerTag = this.unifyLookup.getTagOwnerships().getOwner(tag2);
                if (ownerTag != null) {
                    object.addProperty("tag", ownerTag.location().toString());
                }
            }
            if ((tag2 = object.get("item")) instanceof JsonPrimitive && (tag = this.getPreferredTagForItem(item = ResourceLocation.tryParse((String)(primitive = (JsonPrimitive)tag2).getAsString()))) != null) {
                object.remove("item");
                object.addProperty("tag", tag.location().toString());
            }
        }
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element) {
        return this.createResultReplacement(element, true, "item");
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element, boolean tagLookup, String ... lookupKeys) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        JsonElement result = this.tryCreateResultReplacement(copy, tagLookup, lookupKeys);
        return element.equals(result) ? null : result;
    }

    @Nullable
    private JsonElement tryCreateResultReplacement(JsonElement element, boolean tagLookup, String ... lookupKeys) {
        JsonArray array;
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            ResourceLocation item = ResourceLocation.tryParse((String)primitive.getAsString());
            ResourceLocation replacement = this.getReplacementForItem(item);
            if (replacement != null) {
                return new JsonPrimitive(replacement.toString());
            }
            return null;
        }
        if (element instanceof JsonArray && JsonUtils.replaceOn(array = (JsonArray)element, j -> this.tryCreateResultReplacement((JsonElement)j, tagLookup, lookupKeys))) {
            return element;
        }
        if (element instanceof JsonObject) {
            JsonElement replacement;
            JsonObject object = (JsonObject)element;
            for (String key : lookupKeys) {
                if (!JsonUtils.replaceOn(object, key, j -> this.tryCreateResultReplacement((JsonElement)j, tagLookup, lookupKeys))) continue;
                return element;
            }
            if (tagLookup && (replacement = object.get("tag")) instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)replacement;
                ResourceLocation item = this.getPreferredItemForTag(Utils.toItemTag(primitive.getAsString()));
                if (item != null) {
                    object.remove("tag");
                    object.addProperty("item", item.toString());
                }
                return element;
            }
        }
        return null;
    }

    @Override
    public void unifyInputs(RecipeJson recipe, String recipeKey) {
        JsonElement element = recipe.getProperty(recipeKey);
        if (element != null && this.unifyBasicInput(element)) {
            recipe.markChanged();
        }
    }

    @Override
    public void unifyInputs(RecipeJson recipe, Iterable<String> recipeKeys) {
        for (String recipeKey : recipeKeys) {
            this.unifyInputs(recipe, recipeKey);
        }
    }

    @Override
    public boolean unifyBasicInput(JsonElement jsonElement, Iterable<String> depthInputLookups) {
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            return this.unifySimpleInputs(array, depthInputLookups);
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return this.unifySimpleInputs(object, depthInputLookups);
        }
        return false;
    }

    @Override
    public boolean unifyBasicInput(JsonElement jsonElement) {
        return this.unifyBasicInput(jsonElement, this.defaultInputDepthLookups);
    }

    @Override
    public boolean unifySimpleInputs(JsonArray json, Iterable<String> depthInputLookups) {
        boolean changed = false;
        for (JsonElement element : json) {
            changed |= this.unifyBasicInput(element, depthInputLookups);
        }
        return changed;
    }

    @Override
    public boolean unifySimpleInputs(JsonArray json) {
        return this.unifySimpleInputs(json, this.defaultInputDepthLookups);
    }

    @Override
    public boolean unifySimpleInputs(JsonObject json, Iterable<String> depthInputLookups) {
        boolean changed = false;
        for (String key : depthInputLookups) {
            JsonElement element = json.get(key);
            if (element == null) continue;
            changed |= this.unifyBasicInput(element);
        }
        changed |= this.unifyTagInput(json);
        return changed |= this.unifyItemInput(json);
    }

    @Override
    public boolean unifySimpleInputs(JsonObject json) {
        return this.unifySimpleInputs(json, this.defaultInputDepthLookups);
    }

    @Override
    public boolean unifyItemInput(JsonObject json) {
        JsonPrimitive primitive;
        ResourceLocation item;
        TagKey<Item> tag;
        JsonElement jsonElement = json.get("item");
        if (jsonElement instanceof JsonPrimitive && (tag = this.getPreferredTagForItem(item = ResourceLocation.tryParse((String)(primitive = (JsonPrimitive)jsonElement).getAsString()))) != null) {
            json.remove("item");
            json.addProperty("tag", tag.location().toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean unifyTagInput(JsonObject json) {
        JsonElement jsonElement = json.get("tag");
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            TagKey<Item> tag = Utils.toItemTag(primitive.getAsString());
            TagKey<Item> ownerTag = this.unifyLookup.getTagOwnerships().getOwner(tag);
            if (ownerTag != null) {
                json.addProperty("tag", ownerTag.location().toString());
                return true;
            }
        }
        return false;
    }

    @Override
    public void unifyOutputs(RecipeJson recipe, String recipeKey) {
        this.unifyOutputs(recipe, true, recipeKey);
    }

    @Override
    public void unifyOutputs(RecipeJson recipe, Iterable<String> recipeKeys) {
        for (String recipeKey : recipeKeys) {
            this.unifyOutputs(recipe, recipeKey);
        }
    }

    @Override
    public void unifyOutputs(RecipeJson recipe, String recipeKey, boolean unifyTagToItems, String ... nestedLookupKeys) {
        JsonElement element = recipe.getProperty(recipeKey);
        if (element == null) {
            return;
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonPrimitive replacement = this.createOutputReplacement(primitive);
            if (replacement != null) {
                recipe.setProperty(recipeKey, (JsonElement)replacement);
                recipe.markChanged();
            }
            return;
        }
        if (this.unifyBasicOutput(element, unifyTagToItems, nestedLookupKeys)) {
            recipe.markChanged();
        }
    }

    @Override
    public void unifyOutputs(RecipeJson recipe, boolean unifyTagToItems, String ... keys) {
        for (String key : keys) {
            this.unifyOutputs(recipe, key, unifyTagToItems, "item");
        }
    }

    @Override
    public boolean unifyBasicOutput(JsonObject json, boolean unifyTagToItems, String ... lookupKeys) {
        JsonPrimitive primitive;
        ResourceLocation item;
        JsonElement jsonElement;
        boolean changed = false;
        for (String lookupKey : lookupKeys) {
            JsonElement element = json.get(lookupKey);
            if (element == null) continue;
            if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive2 = (JsonPrimitive)element;
                JsonPrimitive replacement = this.createOutputReplacement(primitive2);
                if (replacement == null) continue;
                json.add(lookupKey, (JsonElement)replacement);
                changed = true;
                continue;
            }
            if (!this.unifyBasicOutput(element, unifyTagToItems, lookupKeys)) continue;
            changed = true;
        }
        if (unifyTagToItems && (jsonElement = json.get("tag")) instanceof JsonPrimitive && (item = this.getPreferredItemForTag(Utils.toItemTag((primitive = (JsonPrimitive)jsonElement).getAsString()))) != null) {
            json.remove("tag");
            json.addProperty("item", item.toString());
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean unifyBasicOutput(JsonArray json, boolean unifyTagToItems, String ... lookupKeys) {
        boolean changed = false;
        for (int i = 0; i < json.size(); ++i) {
            JsonElement element = json.get(i);
            if (element == null) continue;
            if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                JsonPrimitive replacement = this.createOutputReplacement(primitive);
                if (replacement == null) continue;
                json.set(i, (JsonElement)replacement);
                changed = true;
                continue;
            }
            if (!this.unifyBasicOutput(element, unifyTagToItems, lookupKeys)) continue;
            changed = true;
        }
        return changed;
    }

    private boolean unifyBasicOutput(JsonElement json, boolean tagLookup, String ... lookupKeys) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            return this.unifyBasicOutput(obj, tagLookup, lookupKeys);
        }
        if (json instanceof JsonArray) {
            JsonArray arr = (JsonArray)json;
            return this.unifyBasicOutput(arr, tagLookup, lookupKeys);
        }
        return false;
    }

    @Override
    @Nullable
    public JsonPrimitive createOutputReplacement(JsonPrimitive primitive) {
        ResourceLocation item = ResourceLocation.tryParse((String)primitive.getAsString());
        ResourceLocation replacement = this.getReplacementForItem(item);
        if (replacement != null && !replacement.equals((Object)item)) {
            return new JsonPrimitive(replacement.toString());
        }
        return null;
    }
}

