/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.api.recipe.RecipeJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RecipeJsonImpl
implements RecipeJson {
    private final ResourceLocation id;
    private final JsonObject json;
    private boolean changed;

    public RecipeJsonImpl(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.json = json;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getType() {
        try {
            return new ResourceLocation(this.json.get("type").getAsString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not detect recipe type");
        }
    }

    @Override
    public boolean hasProperty(String property) {
        return this.json.has(property);
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    public void markChanged() {
        this.changed = true;
    }

    @Override
    @Nullable
    public JsonElement getProperty(String key) {
        return this.json.get(key);
    }

    @Override
    public void setProperty(String key, JsonElement value) {
        Objects.requireNonNull(value, "value cannot be null");
        this.json.add(key, value);
        this.markChanged();
    }
}

