/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.api.recipe.RecipeData;
import com.almostreliable.unified.utils.JsonCompare;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class RecipeLink
implements RecipeData {
    private final ResourceLocation id;
    private final ResourceLocation type;
    private final JsonObject originalRecipe;
    @Nullable
    private DuplicateLink duplicateLink;
    @Nullable
    private JsonObject unifiedRecipe;

    public RecipeLink(ResourceLocation id, JsonObject originalRecipe) {
        this.id = id;
        this.originalRecipe = originalRecipe;
        try {
            this.type = ResourceLocation.tryParse((String)originalRecipe.get("type").getAsString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not detect recipe type");
        }
    }

    @Nullable
    public static RecipeLink compare(RecipeLink first, RecipeLink second, JsonCompare.CompareSettings compareSettings) {
        JsonObject selfActual = first.getActual();
        JsonObject toCompareActual = second.getActual();
        JsonObject compare = null;
        if (first.getType().toString().equals("minecraft:crafting_shaped")) {
            compare = JsonCompare.compareShaped(selfActual, toCompareActual, compareSettings);
        } else if (JsonCompare.matches(selfActual, toCompareActual, compareSettings)) {
            compare = JsonCompare.compare(compareSettings.getRules(), selfActual, toCompareActual);
        }
        if (compare == null) {
            return null;
        }
        if (compare == selfActual) {
            return first;
        }
        if (compare == toCompareActual) {
            return second;
        }
        return null;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getType() {
        return this.type;
    }

    @Override
    public boolean hasProperty(String property) {
        return this.getOriginal().has(property);
    }

    public JsonObject getOriginal() {
        return this.originalRecipe;
    }

    public boolean hasDuplicateLink() {
        return this.duplicateLink != null;
    }

    @Nullable
    public DuplicateLink getDuplicateLink() {
        return this.duplicateLink;
    }

    private void updateDuplicateLink(@Nullable DuplicateLink duplicateLink) {
        Objects.requireNonNull(duplicateLink);
        if (this.hasDuplicateLink() && this.getDuplicateLink() != duplicateLink) {
            throw new IllegalStateException("Recipe is already linked to " + this.getDuplicateLink());
        }
        this.duplicateLink = duplicateLink;
        this.duplicateLink.addDuplicate(this);
    }

    @Nullable
    public JsonObject getUnified() {
        return this.unifiedRecipe;
    }

    public boolean isUnified() {
        return this.unifiedRecipe != null;
    }

    void setUnified(JsonObject json) {
        Objects.requireNonNull(json);
        if (this.isUnified()) {
            throw new IllegalStateException("Recipe already unified");
        }
        this.unifiedRecipe = json;
    }

    public String toString() {
        String duplicate = this.duplicateLink != null ? " (duplicate)" : "";
        String unified = this.unifiedRecipe != null ? " (unified)" : "";
        return String.format("['%s'] %s%s%s", this.type, this.id, duplicate, unified);
    }

    public boolean handleDuplicate(RecipeLink otherRecipe, JsonCompare.CompareSettings compareSettings) {
        DuplicateLink selfDuplicate = this.getDuplicateLink();
        DuplicateLink otherDuplicate = otherRecipe.getDuplicateLink();
        if (selfDuplicate != null && otherDuplicate != null) {
            return selfDuplicate == otherDuplicate;
        }
        if (selfDuplicate == null && otherDuplicate == null) {
            RecipeLink compare = RecipeLink.compare(this, otherRecipe, compareSettings);
            if (compare == null) {
                return false;
            }
            DuplicateLink newLink = new DuplicateLink(compare);
            this.updateDuplicateLink(newLink);
            otherRecipe.updateDuplicateLink(newLink);
            return true;
        }
        if (otherDuplicate != null) {
            RecipeLink compare = RecipeLink.compare(this, otherDuplicate.getMaster(), compareSettings);
            if (compare == null) {
                return false;
            }
            otherDuplicate.updateMaster(compare);
            this.updateDuplicateLink(otherDuplicate);
            return true;
        }
        RecipeLink compare = RecipeLink.compare(selfDuplicate.getMaster(), otherRecipe, compareSettings);
        if (compare == null) {
            return false;
        }
        selfDuplicate.updateMaster(compare);
        otherRecipe.updateDuplicateLink(selfDuplicate);
        return true;
    }

    public JsonObject getActual() {
        return this.getUnified() != null ? this.getUnified() : this.getOriginal();
    }

    public static final class DuplicateLink {
        private final Set<RecipeLink> recipes = new HashSet<RecipeLink>();
        private RecipeLink currentMaster;

        private DuplicateLink(RecipeLink master) {
            this.updateMaster(master);
        }

        private void updateMaster(RecipeLink master) {
            Objects.requireNonNull(master);
            this.addDuplicate(master);
            this.currentMaster = master;
        }

        private void addDuplicate(RecipeLink recipe) {
            this.recipes.add(recipe);
        }

        public RecipeLink getMaster() {
            return this.currentMaster;
        }

        public Set<RecipeLink> getRecipes() {
            return Collections.unmodifiableSet(this.recipes);
        }

        public Set<RecipeLink> getRecipesWithoutMaster() {
            return this.recipes.stream().filter(recipe -> recipe != this.currentMaster).collect(Collectors.toSet());
        }

        public String toString() {
            return "Link{currentMaster=" + this.currentMaster + ", recipes=" + this.recipes.size() + "}";
        }
    }
}

