/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.UnifierRegistry;
import com.almostreliable.unified.api.UnifyHandler;
import com.almostreliable.unified.api.UnifySettings;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.config.DuplicationConfig;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.recipe.RecipeContextImpl;
import com.almostreliable.unified.recipe.RecipeJsonImpl;
import com.almostreliable.unified.recipe.RecipeLink;
import com.almostreliable.unified.utils.JsonCompare;
import com.almostreliable.unified.utils.JsonQuery;
import com.almostreliable.unified.utils.RecipeTypePropertiesLogger;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class RecipeTransformer {
    private final UnifierRegistry factory;
    private final Collection<? extends UnifyHandler> unifyHandlers;
    private final DuplicationConfig duplicationConfig;
    private final RecipeTypePropertiesLogger propertiesLogger = new RecipeTypePropertiesLogger();

    public RecipeTransformer(UnifierRegistry factory, Collection<? extends UnifyHandler> unifyHandlers, DuplicationConfig duplicationConfig) {
        this.factory = factory;
        this.unifyHandlers = unifyHandlers;
        this.duplicationConfig = duplicationConfig;
    }

    public Result transformRecipes(Map<ResourceLocation, JsonElement> recipes, boolean skipClientTracking) {
        Stopwatch transformationTimer = Stopwatch.createStarted();
        AlmostUnified.LOG.warn("Recipe count: " + recipes.size());
        ClientRecipeTracker.RawBuilder tracker = skipClientTracking ? null : new ClientRecipeTracker.RawBuilder();
        Result result = new Result();
        Map<ResourceLocation, List<RecipeLink>> byType = this.groupRecipesByType(recipes);
        ResourceLocation fcLocation = new ResourceLocation("forge:conditional");
        byType.forEach((type, recipeLinks) -> {
            if (type.equals((Object)fcLocation)) {
                recipeLinks.forEach(recipeLink -> this.handleForgeConditionals((RecipeLink)recipeLink).ifPresent(json -> recipes.put(recipeLink.getId(), (JsonElement)json)));
            } else {
                this.transformRecipes((List<RecipeLink>)recipeLinks, recipes, tracker);
            }
            result.addAll((Collection<RecipeLink>)recipeLinks);
        });
        AlmostUnified.LOG.warn("Recipe count afterwards: " + recipes.size() + " (done in " + transformationTimer.stop() + ")");
        this.unifyHandlers.forEach(UnifySettings::clearCache);
        this.duplicationConfig.clearCache();
        if (tracker != null) {
            recipes.putAll(tracker.compute());
        }
        return result;
    }

    private Optional<JsonObject> handleForgeConditionals(RecipeLink recipeLink) {
        JsonObject copy = recipeLink.getOriginal().deepCopy();
        JsonElement jsonElement = copy.get("recipes");
        if (jsonElement instanceof JsonArray) {
            JsonArray recipes = (JsonArray)jsonElement;
            for (JsonElement element : recipes) {
                JsonQuery.of(element, "recipe").asObject().map(jsonObject -> new RecipeLink(recipeLink.getId(), (JsonObject)jsonObject)).ifPresent(temporaryLink -> {
                    this.unifyRecipe((RecipeLink)temporaryLink);
                    if (temporaryLink.isUnified()) {
                        element.getAsJsonObject().add("recipe", (JsonElement)temporaryLink.getUnified());
                    }
                });
            }
            if (!copy.equals((Object)recipeLink.getOriginal())) {
                recipeLink.setUnified(copy);
                return Optional.of(copy);
            }
        }
        return Optional.empty();
    }

    private void transformRecipes(List<RecipeLink> recipeLinks, Map<ResourceLocation, JsonElement> allRecipes, @Nullable ClientRecipeTracker.RawBuilder tracker) {
        LinkedHashSet<RecipeLink> unified = this.unifyRecipes(recipeLinks, r -> allRecipes.put(r.getId(), (JsonElement)r.getUnified()));
        Set<RecipeLink.DuplicateLink> duplicates = this.handleDuplicates(this.duplicationConfig.isStrictMode() ? recipeLinks : unified, recipeLinks);
        duplicates.stream().flatMap(d -> d.getRecipesWithoutMaster().stream()).forEach(r -> allRecipes.remove(r.getId()));
        if (tracker != null) {
            unified.forEach(tracker::add);
        }
    }

    public Map<ResourceLocation, List<RecipeLink>> groupRecipesByType(Map<ResourceLocation, JsonElement> recipes) {
        return recipes.entrySet().stream().map(entry -> new RecipeLink((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).sorted(Comparator.comparing(entry -> entry.getId().toString())).collect(Collectors.groupingByConcurrent(RecipeLink::getType));
    }

    private Set<RecipeLink.DuplicateLink> handleDuplicates(Collection<RecipeLink> recipeLinks, List<RecipeLink> linksToCompare) {
        HashSet<RecipeLink.DuplicateLink> duplicates = new HashSet<RecipeLink.DuplicateLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            if (!this.handleDuplicate(recipeLink, linksToCompare) || recipeLink.getDuplicateLink() == null) continue;
            duplicates.add(recipeLink.getDuplicateLink());
        }
        return duplicates;
    }

    private boolean handleDuplicate(RecipeLink curRecipe, List<RecipeLink> recipes) {
        if (this.duplicationConfig.shouldIgnoreRecipe(curRecipe)) {
            return false;
        }
        JsonCompare.CompareSettings compareSettings = this.duplicationConfig.getCompareSettings(curRecipe.getType());
        boolean foundDuplicate = false;
        for (RecipeLink recipeLink : recipes) {
            if (!curRecipe.getType().equals((Object)recipeLink.getType())) {
                throw new IllegalStateException("Recipe types do not match for " + curRecipe.getId() + " and " + recipeLink.getId());
            }
            if (recipeLink == curRecipe || this.duplicationConfig.shouldIgnoreRecipe(recipeLink)) continue;
            foundDuplicate |= curRecipe.handleDuplicate(recipeLink, compareSettings);
        }
        return foundDuplicate;
    }

    private LinkedHashSet<RecipeLink> unifyRecipes(List<RecipeLink> recipeLinks, Consumer<RecipeLink> onUnified) {
        LinkedHashSet<RecipeLink> unified = new LinkedHashSet<RecipeLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            this.unifyRecipe(recipeLink);
            if (!recipeLink.isUnified()) continue;
            onUnified.accept(recipeLink);
            unified.add(recipeLink);
        }
        return unified;
    }

    public void unifyRecipe(RecipeLink recipe) {
        try {
            JsonObject maybeUnified = recipe.getOriginal().deepCopy();
            RecipeJsonImpl json = new RecipeJsonImpl(recipe.getId(), maybeUnified);
            for (UnifyHandler unifyHandler : this.unifyHandlers) {
                if (!unifyHandler.shouldIncludeRecipe(recipe)) continue;
                RecipeContextImpl ctx = new RecipeContextImpl(unifyHandler);
                RecipeUnifier unifier = this.factory.getUnifier(recipe);
                unifier.unifyItems(ctx, json);
            }
            if (json.changed()) {
                recipe.setUnified(maybeUnified);
            }
            this.propertiesLogger.log(recipe.getType(), recipe.getOriginal());
        }
        catch (Exception e) {
            AlmostUnified.LOG.warn("Error unifying recipe '{}': {}", (Object)recipe.getId(), (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static class Result {
        private final Multimap<ResourceLocation, RecipeLink> allRecipesByType = HashMultimap.create();
        private final Multimap<ResourceLocation, RecipeLink> unifiedRecipesByType = HashMultimap.create();
        private final Multimap<ResourceLocation, RecipeLink.DuplicateLink> duplicatesByType = HashMultimap.create();

        private void add(RecipeLink link) {
            if (this.allRecipesByType.containsEntry((Object)link.getType(), (Object)link)) {
                throw new IllegalStateException("Already tracking recipe type " + link.getType());
            }
            this.allRecipesByType.put((Object)link.getType(), (Object)link);
            if (link.isUnified()) {
                this.unifiedRecipesByType.put((Object)link.getType(), (Object)link);
            }
            if (link.hasDuplicateLink()) {
                this.duplicatesByType.put((Object)link.getType(), (Object)link.getDuplicateLink());
            }
        }

        private void addAll(Collection<RecipeLink> links) {
            links.forEach(this::add);
        }

        public Collection<RecipeLink> getRecipes(ResourceLocation type) {
            return Collections.unmodifiableCollection(this.allRecipesByType.get((Object)type));
        }

        public Collection<RecipeLink> getUnifiedRecipes(ResourceLocation type) {
            return Collections.unmodifiableCollection(this.unifiedRecipesByType.get((Object)type));
        }

        public Collection<RecipeLink.DuplicateLink> getDuplicates(ResourceLocation type) {
            return Collections.unmodifiableCollection(this.duplicatesByType.get((Object)type));
        }

        public int getRecipeCount() {
            return this.allRecipesByType.size();
        }

        public int getUnifiedRecipeCount() {
            return this.unifiedRecipesByType.size();
        }

        public int getDuplicatesCount() {
            return this.duplicatesByType.size();
        }

        public int getDuplicateRecipesCount() {
            return this.duplicatesByType.values().stream().mapToInt(l -> l.getRecipes().size()).sum();
        }

        public Set<ResourceLocation> getUnifiedRecipeTypes() {
            return this.unifiedRecipesByType.keySet();
        }
    }
}

