/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe.unifier;

import com.almostreliable.unified.api.UnifierRegistry;
import com.almostreliable.unified.api.recipe.RecipeData;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.recipe.unifier.GenericRecipeUnifier;
import com.almostreliable.unified.recipe.unifier.ShapedRecipeUnifier;
import com.almostreliable.unified.recipe.unifier.SmithingRecipeUnifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class UnifierRegistryImpl
implements UnifierRegistry {
    private final Map<ResourceLocation, RecipeUnifier> transformersByType = new HashMap<ResourceLocation, RecipeUnifier>();
    private final Map<String, RecipeUnifier> transformersByModId = new HashMap<String, RecipeUnifier>();

    @Override
    public RecipeUnifier getUnifier(RecipeData recipeData) {
        ResourceLocation type = recipeData.getType();
        RecipeUnifier byType = this.transformersByType.get(type);
        if (byType != null) {
            return byType;
        }
        RecipeUnifier byMod = this.transformersByModId.get(type.getNamespace());
        if (byMod != null) {
            return byMod;
        }
        if (SmithingRecipeUnifier.INSTANCE.matches(recipeData)) {
            return SmithingRecipeUnifier.INSTANCE;
        }
        if (recipeData.hasProperty("pattern") && recipeData.hasProperty("key")) {
            return ShapedRecipeUnifier.INSTANCE;
        }
        return GenericRecipeUnifier.INSTANCE;
    }

    @Override
    public void registerForType(ResourceLocation type, RecipeUnifier transformer) {
        this.transformersByType.put(type, transformer);
    }

    @Override
    public void registerForMod(String mod, RecipeUnifier transformer) {
        this.transformersByModId.put(mod, transformer);
    }
}

