/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public final class FileUtils {
    private FileUtils() {
    }

    public static void write(Path path, String fileName, Consumer<StringBuilder> callback) {
        StringBuilder sb = new StringBuilder();
        callback.accept(sb);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path filePath = path.resolve(fileName);
            Files.writeString(filePath, (CharSequence)sb.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            AlmostUnified.LOG.warn("Dump couldn't be written '{}': {}", (Object)fileName, (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void createGitIgnoreIfNotExists() {
        Path path = AlmostUnifiedPlatform.INSTANCE.getConfigPath();
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getConfigPath(), ".gitignore", sb -> sb.append("debug").append(".json").append("\n"));
        }
    }
}

