/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.utils.FileUtils;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class RecipeTypePropertiesLogger {
    private final Map<String, List<String>> properties = new HashMap<String, List<String>>();

    private List<String> getProperties(String mod) {
        return this.properties.computeIfAbsent(mod, $ -> new ArrayList());
    }

    public void log(ResourceLocation recipeType, JsonObject recipe) {
        String mod = recipeType.getNamespace();
        recipe.entrySet().forEach(e -> this.getProperties(mod).add((String)e.getKey()));
    }

    public void log(String mod, String property) {
        this.getProperties(mod).add(property);
    }

    public void writeFile() {
        StringBuilder sb = new StringBuilder();
        this.properties.forEach((mod, props) -> {
            sb.append((String)mod).append(":\n");
            props.sort(String::compareTo);
            props.forEach(property -> sb.append("    ").append((String)property).append("\n"));
        });
        Path path = AlmostUnifiedPlatform.INSTANCE.getLogPath();
        FileUtils.write(path, "debug_recipe_properties.txt", stringBuilder -> sb.append((CharSequence)sb));
    }
}

