/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public final class Utils {
    public static final ResourceLocation UNUSED_ID = new ResourceLocation("almostunified", "unused_id");
    public static final TagKey<Item> UNUSED_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)UNUSED_ID);

    private Utils() {
    }

    public static TagKey<Item> toItemTag(@Nullable String tag) {
        if (tag == null) {
            return UNUSED_TAG;
        }
        ResourceLocation rl = ResourceLocation.tryParse((String)tag);
        if (rl == null) {
            return UNUSED_TAG;
        }
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl);
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    public static ResourceLocation getRL(String path) {
        return new ResourceLocation("almostunified", path);
    }

    public static String prefix(String path) {
        return "almostunified." + path;
    }

    public static boolean allSameNamespace(Set<ResourceLocation> ids) {
        if (ids.size() <= 1) {
            return true;
        }
        Iterator<ResourceLocation> it = ids.iterator();
        String namespace = it.next().getNamespace();
        while (it.hasNext()) {
            if (it.next().getNamespace().equals(namespace)) continue;
            return false;
        }
        return true;
    }
}

