/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.world.processor;

import bagu_chan.bagus_lib.register.ModStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BaseProcessor
extends StructureProcessor {
    public static final Codec<BaseProcessor> CODEC = RecordCodecBuilder.create(p_74116_ -> p_74116_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(p_163729_ -> p_163729_.baseBlock), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("replace_block").forGetter(p_163727_ -> p_163727_.replaceBlock)).apply((Applicative)p_74116_, BaseProcessor::new));
    public final Block baseBlock;
    public final Block replaceBlock;

    public BaseProcessor(Block baseBlock, Block replaceBlock) {
        this.baseBlock = baseBlock;
        this.replaceBlock = replaceBlock;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() == this.baseBlock) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), this.replaceBlock.defaultBlockState(), blockInfoGlobal.nbt());
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().mutable().move(Direction.DOWN);
            BlockState currBlockState = levelReader.getBlockState((BlockPos)mutable);
            while (mutable.getY() > levelReader.getMinBuildHeight() && mutable.getY() < levelReader.getMaxBuildHeight() && (currBlockState.isAir() || !levelReader.getFluidState((BlockPos)mutable).isEmpty())) {
                levelReader.getChunk((BlockPos)mutable).setBlockState((BlockPos)mutable, this.replaceBlock.defaultBlockState(), false);
                mutable.move(Direction.DOWN);
                currBlockState = levelReader.getBlockState((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return ModStructureProcessorTypes.BASE.get();
    }
}

