/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeTitleCommand {
    public static final DynamicCommandExceptionType BIOME_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> Component.translatable((String)"travelerstitles.commands.biometitle.notfound", (Object[])new Object[]{formatArgs}));
    public static final DynamicCommandExceptionType INVALID_BIOME_EXCEPTION = new DynamicCommandExceptionType(formatArgs -> Component.translatable((String)"travelerstitles.commands.biometitle.invalid", (Object[])new Object[]{formatArgs}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"biometitle").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"biome", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BIOME)).executes(ctx -> BiomeTitleCommand.displayTitle((CommandSourceStack)ctx.getSource(), (ResourceOrTagKeyArgument.Result<Biome>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"biome", (ResourceKey)Registries.BIOME, (DynamicCommandExceptionType)INVALID_BIOME_EXCEPTION)))));
    }

    public static int displayTitle(CommandSourceStack commandSource, ResourceOrTagKeyArgument.Result<Biome> biomeResult) throws CommandSyntaxException {
        MutableComponent biomeTitle;
        ResourceLocation biomeBaseKey;
        try {
            biomeBaseKey = new ResourceLocation(biomeResult.asPrintable());
        }
        catch (ResourceLocationException e) {
            throw INVALID_BIOME_EXCEPTION.create((Object)biomeResult.asPrintable());
        }
        String overrideBiomeNameKey = Util.makeDescriptionId((String)"travelerstitles.biome", (ResourceLocation)biomeBaseKey);
        String normalBiomeNameKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)biomeBaseKey);
        if (TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist.contains(biomeBaseKey.toString())) {
            commandSource.sendSuccess(() -> Component.literal((String)"That biome is blacklisted, so its title won't normally show!"), false);
        }
        if (Language.getInstance().has(overrideBiomeNameKey)) {
            biomeTitle = Component.translatable((String)overrideBiomeNameKey);
        } else if (Language.getInstance().has(normalBiomeNameKey)) {
            biomeTitle = Component.translatable((String)normalBiomeNameKey);
        } else {
            throw BIOME_NOT_FOUND_EXCEPTION.create((Object)biomeResult.asPrintable());
        }
        String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
        String normalBiomeColorKey = normalBiomeNameKey + ".color";
        String biomeColorStr = Language.getInstance().has(overrideBiomeColorKey) ? Language.getInstance().getOrDefault(overrideBiomeColorKey) : (Language.getInstance().has(normalBiomeColorKey) ? Language.getInstance().getOrDefault(normalBiomeColorKey) : TravelersTitlesCommon.titleManager.biomeTitleRenderer.titleDefaultTextColor);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.setColor(biomeColorStr);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.displayTitle((Component)biomeTitle, null);
        TravelersTitlesCommon.titleManager.biomeTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.biomes.textCooldownTime;
        return 1;
    }
}

