/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.services;

import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.module.ConfigModule;
import com.yungnickyoung.minecraft.travelerstitles.module.SoundModule;
import com.yungnickyoung.minecraft.travelerstitles.render.TitleRenderer;
import com.yungnickyoung.minecraft.travelerstitles.services.IWaystonesCompatHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

public class NeoForgeWaystonesCompatHelper
implements IWaystonesCompatHelper {
    private List<Waystone> knownWaystones = new ArrayList<Waystone>();
    private Set<Waystone> sharestones = new HashSet<Waystone>();
    private Waystone closestWaystone;
    private int waystoneUpdateTimer = 0;
    private final TitleRenderer<Waystone> waystoneTitleRenderer;

    public NeoForgeWaystonesCompatHelper() {
        this.waystoneTitleRenderer = new TitleRenderer(TravelersTitlesCommon.CONFIG.waystones.recentWaystoneCacheSize, TravelersTitlesCommon.CONFIG.waystones.enabled, TravelersTitlesCommon.CONFIG.waystones.textFadeInTime, TravelersTitlesCommon.CONFIG.waystones.textDisplayTime, TravelersTitlesCommon.CONFIG.waystones.textFadeOutTime, TravelersTitlesCommon.CONFIG.waystones.textColor, TravelersTitlesCommon.CONFIG.waystones.renderShadow, TravelersTitlesCommon.CONFIG.waystones.textSize, TravelersTitlesCommon.CONFIG.waystones.textXOffset, TravelersTitlesCommon.CONFIG.waystones.textYOffset, TravelersTitlesCommon.CONFIG.waystones.centerText);
    }

    @Override
    public void init() {
        NeoForge.EVENT_BUS.addListener(this::onWaystoneListReceived);
        NeoForge.EVENT_BUS.addListener(this::updateClosestWaystone);
    }

    private void onWaystoneListReceived(WaystonesListReceivedEvent event) {
        if (event.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            this.knownWaystones = event.getWaystones();
        } else if (WaystoneTypes.isSharestone((ResourceLocation)event.getWaystoneType())) {
            this.sharestones.addAll(event.getWaystones());
        }
    }

    private void updateClosestWaystone(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        ++this.waystoneUpdateTimer;
        if (this.waystoneUpdateTimer % 10 == 0) {
            double sqDistance;
            String playerDimension = player.level().dimension().location().toString();
            BlockPos playerPos = player.blockPosition();
            double minSqDist = Double.MAX_VALUE;
            for (Waystone waystone : this.knownWaystones) {
                String waystoneDimension = waystone.getDimension().location().toString();
                if (!waystone.hasName() || !playerDimension.equals(waystoneDimension) || !((sqDistance = waystone.getPos().distSqr((Vec3i)playerPos)) < minSqDist)) continue;
                minSqDist = sqDistance;
                this.closestWaystone = waystone;
            }
            for (Waystone sharestone : this.sharestones) {
                String sharestoneDimension = sharestone.getDimension().location().toString();
                if (!sharestone.hasName() || !playerDimension.equals(sharestoneDimension) || !((sqDistance = sharestone.getPos().distSqr((Vec3i)playerPos)) < minSqDist)) continue;
                minSqDist = sqDistance;
                this.closestWaystone = sharestone;
            }
            int range = TravelersTitlesCommon.CONFIG.waystones.range;
            if (minSqDist > (double)(range * range)) {
                this.closestWaystone = null;
            }
        }
    }

    @Override
    public boolean updateWaystoneTitle(Player player) {
        boolean hasTitleChanged;
        Waystone _closestWaystone = this.closestWaystone;
        if (_closestWaystone == null || !_closestWaystone.hasName()) {
            return this.waystoneTitleRenderer.titleTimer > 0;
        }
        boolean shouldUpdateTitle = this.waystoneTitleRenderer.enabled && this.waystoneTitleRenderer.cooldownTimer <= 0 && !this.waystoneTitleRenderer.matchesAnyRecentEntry(w -> w.getName().equals(_closestWaystone.getName()));
        boolean bl = hasTitleChanged = this.waystoneTitleRenderer.displayedTitle == null || !_closestWaystone.getName().equals(this.waystoneTitleRenderer.displayedTitle.getString());
        if (shouldUpdateTitle && hasTitleChanged) {
            this.waystoneTitleRenderer.setColor(this.waystoneTitleRenderer.titleDefaultTextColor);
            this.waystoneTitleRenderer.displayTitle(_closestWaystone.getName(), null);
            this.waystoneTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.waystones.textCooldownTime;
            this.waystoneTitleRenderer.addRecentEntry(_closestWaystone);
            if (TravelersTitlesCommon.titleManager.dimensionTitleRenderer.titleTimer <= 0) {
                player.playSound((SoundEvent)SoundModule.WAYSTONE.get(), (float)TravelersTitlesCommon.CONFIG.sound.waystoneVolume, (float)TravelersTitlesCommon.CONFIG.sound.waystonePitch);
            }
        }
        return this.waystoneTitleRenderer.titleTimer > 0;
    }

    @Override
    public void clientTick() {
        this.waystoneTitleRenderer.tick();
    }

    @Override
    public void renderText(float partialTicks, GuiGraphics guiGraphics) {
        this.waystoneTitleRenderer.renderText(partialTicks, guiGraphics);
    }

    @Override
    public void reset() {
        this.waystoneTitleRenderer.clearTimer();
        this.waystoneTitleRenderer.recentEntries.clear();
        this.waystoneTitleRenderer.displayedTitle = null;
    }

    @Override
    public boolean isRendering() {
        return this.waystoneTitleRenderer.titleTimer > 0;
    }

    @Override
    public void updateRendererFromConfig(ConfigModule.Waystones config) {
        this.waystoneTitleRenderer.maxRecentListSize = config.recentWaystoneCacheSize;
        this.waystoneTitleRenderer.enabled = config.enabled;
        this.waystoneTitleRenderer.titleFadeInTicks = config.textFadeInTime;
        this.waystoneTitleRenderer.titleDisplayTime = config.textDisplayTime;
        this.waystoneTitleRenderer.titleFadeOutTicks = config.textFadeOutTime;
        this.waystoneTitleRenderer.titleDefaultTextColor = config.textColor;
        this.waystoneTitleRenderer.showTextShadow = config.renderShadow;
        this.waystoneTitleRenderer.titleTextSize = (float)config.textSize;
        this.waystoneTitleRenderer.titleXOffset = config.textXOffset;
        this.waystoneTitleRenderer.titleYOffset = config.textYOffset;
        this.waystoneTitleRenderer.isTextCentered = config.centerText;
    }
}

