/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public final class JadeClient {
    public static final SystemToast.SystemToastId JADE_TUTORIAL = new SystemToast.SystemToastId(10000L);
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showDetails;
    public static KeyMapping narrate;
    public static KeyMapping showRecipes;
    public static KeyMapping showUses;
    public static boolean hideModName;
    private static boolean translationChecked;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public static void init() {
        openConfig = ClientProxy.registerKeyBinding("config", 320);
        showOverlay = ClientProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientProxy.registerKeyBinding("narrate", 325);
        showDetails = ClientProxy.registerDetailsKeyBinding();
        ClientProxy.registerReloadListener(ModIdentification.INSTANCE);
    }

    public static void onKeyPressed(int action) {
        while (openConfig.consumeClick()) {
            Jade.CONFIG.invalidate();
            ItemStorageProvider.INSTANCE.targetCache.invalidateAll();
            ItemStorageProvider.INSTANCE.containerCache.invalidateAll();
            Minecraft.getInstance().setScreen((Screen)new HomeConfigScreen(null));
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        while (showOverlay.consumeClick()) {
            IWailaConfig.DisplayMode mode = general.getDisplayMode();
            if (mode != IWailaConfig.DisplayMode.TOGGLE) continue;
            general.setDisplayTooltip(!general.shouldDisplayTooltip());
            if (!general.shouldDisplayTooltip() && general.hintOverlayToggle) {
                SystemToast.add((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)JADE_TUTORIAL, (Component)Component.translatable((String)"toast.jade.toggle_hint.1"), (Component)Component.translatable((String)"toast.jade.toggle_hint.2", (Object[])new Object[]{showOverlay.getTranslatedKeyMessage()}));
                general.hintOverlayToggle = false;
            }
            Jade.CONFIG.save();
        }
        while (toggleLiquid.consumeClick()) {
            general.setDisplayFluids(!general.shouldDisplayFluids());
            Jade.CONFIG.save();
        }
        while (narrate.consumeClick()) {
            if (general.getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                general.toggleTTS();
                if (general.shouldEnableTextToSpeech() && general.hintNarratorToggle) {
                    SystemToast.add((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)JADE_TUTORIAL, (Component)Component.translatable((String)"toast.jade.tts_hint.1"), (Component)Component.translatable((String)"toast.jade.tts_hint.2", (Object[])new Object[]{narrate.getTranslatedKeyMessage()}));
                    general.hintNarratorToggle = false;
                }
                Jade.CONFIG.save();
                continue;
            }
            if (WailaTickHandler.instance().rootElement == null) continue;
            WailaTickHandler.narrate(WailaTickHandler.instance().rootElement.getTooltip(), false);
        }
    }

    public static void onGui(Screen screen) {
        if (!translationChecked && screen instanceof TitleScreen && CommonProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (ResourceLocation id : PluginConfig.INSTANCE.getKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.getNamespace(), id.getPath());
                if (I18n.exists((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(Joiner.on((char)',').join((Iterable)keys)));
            }
        }
    }

    public static void onTooltip(List<Component> tooltip, ItemStack stack, TooltipFlag context) {
        JadeClient.appendModName(tooltip, stack, context);
        if (Jade.CONFIG.get().getGeneral().isDebug() && stack.hasTag()) {
            tooltip.add(NbtUtils.toPrettyComponent((Tag)stack.getTag()));
        }
    }

    private static void appendModName(List<Component> tooltip, ItemStack stack, TooltipFlag context) {
        int i;
        if (hideModName || !Jade.CONFIG.get().getGeneral().showItemModNameTooltip()) {
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            if (!(screen2.hoveredSlot == null || screen2.hoveredSlot.getItem() != stack || CreativeModeInventoryScreen.selectedTab.getType() == CreativeModeTab.Type.CATEGORY && context.isCreative())) {
                return;
            }
        }
        String name = ModIdentification.getModName(stack);
        for (i = 1; i < tooltip.size() && !Objects.equals(tooltip.get(i).getString(), name); ++i) {
        }
        tooltip.add(i, (Component)Component.literal((String)name).withStyle(Jade.CONFIG.get().getFormatting().getItemModNameStyle()));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (WailaClientRegistration.instance().maybeLowVisionUser() || !IWailaConfig.get().getGeneral().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            BlockState state;
            BlockAccessor target = (BlockAccessor)accessor;
            Player player = accessor.getPlayer();
            if (player.isCreative() || player.isSpectator()) {
                return accessor;
            }
            IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
            if (target.getBlock() instanceof TrappedChestBlock && (state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState())) != target.getBlockState()) {
                return client.blockAccessor().from(target).blockState(state).build();
            }
            BlockAccessor.Builder builder = client.blockAccessor().from(target).blockEntity(() -> null);
            if (target.getBlock() instanceof InfestedBlock) {
                Block block = ((InfestedBlock)target.getBlock()).getHostBlock();
                return builder.blockState(block.defaultBlockState()).build();
            }
            if (target.getBlock() == Blocks.POWDER_SNOW) {
                Block block = Blocks.SNOW_BLOCK;
                return builder.blockState(block.defaultBlockState()).build();
            }
            Block block = target.getBlock();
            if (block instanceof BrushableBlock) {
                BrushableBlock brushable = (BrushableBlock)block;
                block = brushable.getTurnsInto();
                return builder.blockState(block.defaultBlockState()).build();
            }
        }
        return accessor;
    }

    @Nullable
    public static Accessor<?> limitMobEffectFog(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (accessor == null) {
            return null;
        }
        Player player = accessor.getPlayer();
        Minecraft mc = Minecraft.getInstance();
        LightTexture lightTexture = mc.gameRenderer.lightTexture();
        float darknessEffectScale = ((Double)mc.options.darknessEffectScale().get()).floatValue();
        float gamma = lightTexture.getDarknessGamma(1.0f) * darknessEffectScale;
        if ((gamma = lightTexture.calculateDarknessScale((LivingEntity)player, gamma, 1.0f)) > 0.15f && accessor.getLevel().getMaxLocalRawBrightness(BlockPos.containing((Position)accessor.getHitResult().getLocation())) < 7) {
            return null;
        }
        FogRenderer.MobEffectFogFunction fogFunction = FogRenderer.getPriorityFogFunction((Entity)player, (float)1.0f);
        if (fogFunction == null) {
            return accessor;
        }
        FogRenderer.FogData fogData = new FogRenderer.FogData(FogRenderer.FogMode.FOG_TERRAIN);
        fogFunction.setupFog(fogData, (LivingEntity)player, player.getEffect(fogFunction.getMobEffect()), Math.max(32.0f, mc.gameRenderer.getRenderDistance()), 1.0f);
        float dist = (fogData.start + fogData.end) * 0.5f;
        if (accessor.getHitResult().distanceTo((Entity)player) > (double)(dist * dist)) {
            return null;
        }
        return accessor;
    }

    public static void drawBreakingProgress(IBoxElement rootElement, TooltipRect rect, GuiGraphics guiGraphics, Accessor<?> accessor) {
        boolean roundCorner;
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        if (!Float.isNaN(rootElement.getBoxProgress())) {
            progressAlpha = 0.0f;
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        MultiPlayerGameMode playerController = mc.gameMode;
        if (playerController == null || mc.level == null || mc.player == null) {
            return;
        }
        BlockState state = mc.level.getBlockState(playerController.destroyBlockPos);
        if (playerController.isDestroying()) {
            canHarvest = CommonProxy.isCorrectToolForDrops(state, (Player)mc.player);
        } else if (progressAlpha == 0.0f) {
            return;
        }
        Theme theme = IThemeHelper.get().theme();
        ColorPalette colors = theme.tooltipStyle.boxProgressColors;
        int color = canHarvest ? colors.normal() : colors.failure();
        float top = rootElement.getCachedSize().y;
        float width = rootElement.getCachedSize().x;
        boolean bl = roundCorner = !IWailaConfig.get().getOverlay().getSquare();
        if (roundCorner && theme.tooltipStyle instanceof BoxStyle.GradientBorder) {
            top += 1.0f;
        }
        progressAlpha += mc.getDeltaFrameTime() * (playerController.isDestroying() ? 0.1f : -0.1f);
        if (playerController.isDestroying()) {
            progressAlpha = Math.min(progressAlpha, 0.6f);
            float progress = state.getDestroyProgress((Player)mc.player, (BlockGetter)mc.player.level(), playerController.destroyBlockPos);
            if (playerController.destroyProgress + progress >= 1.0f) {
                savedProgress = 1.0f;
                progressAlpha = 1.0f;
            } else {
                progress = playerController.destroyProgress + mc.getFrameTime() * progress;
                savedProgress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
            }
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        if (progressAlpha == 0.0f) {
            return;
        }
        color = IWailaConfig.IConfigOverlay.applyAlpha(color, progressAlpha);
        float offset0 = theme.tooltipStyle.boxProgressOffset(Direction2D.UP);
        float offset1 = theme.tooltipStyle.boxProgressOffset(Direction2D.RIGHT);
        float offset2 = theme.tooltipStyle.boxProgressOffset(Direction2D.DOWN);
        float offset3 = theme.tooltipStyle.boxProgressOffset(Direction2D.LEFT);
        DisplayHelper.fill(guiGraphics, offset3, top - 1.0f + offset0, offset3 + (width += offset1 - offset3) * savedProgress, top + offset2, color);
    }

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.literal((String)MessageFormat.format(I18n.get((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.translatable((String)s, (Object[])objects);
        }
    }
}

