/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.core;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.impl.WailaClientRegistration;

public enum ObjectNameProvider implements IBlockComponentProvider,
IEntityComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public static Component getEntityName(Entity entity) {
        if (!entity.hasCustomName()) {
            Display.BlockDisplay blockDisplay;
            Display.ItemDisplay itemDisplay;
            ItemStack stack;
            if (WailaClientRegistration.instance().shouldPick(entity) && (stack = entity.getPickResult()) != null && !stack.isEmpty()) {
                return stack.getHoverName();
            }
            if (entity instanceof Villager) {
                return entity.getType().getDescription();
            }
            if (entity instanceof ItemEntity) {
                return ((ItemEntity)entity).getItem().getHoverName();
            }
            if (entity instanceof Display.ItemDisplay && !(itemDisplay = (Display.ItemDisplay)entity).getSlot(0).get().isEmpty()) {
                return itemDisplay.getSlot(0).get().getHoverName();
            }
            if (entity instanceof Display.BlockDisplay && !(blockDisplay = (Display.BlockDisplay)entity).getBlockState().isAir()) {
                return blockDisplay.getBlockState().getBlock().getName();
            }
        }
        return entity.getName();
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        Object name = null;
        if (accessor.getServerData().contains("givenName", 8)) {
            name = Component.Serializer.fromJson((String)accessor.getServerData().getString("givenName"));
        }
        if (name == null && accessor.isFakeBlock()) {
            name = accessor.getFakeBlock().getHoverName();
        }
        if (name == null && WailaClientRegistration.instance().shouldPick(accessor.getBlockState()) && (pick = accessor.getPickedResult()) != null && !pick.isEmpty()) {
            name = pick.getHoverName();
        }
        if (name == null) {
            ItemStack pick2;
            String key = accessor.getBlock().getDescriptionId();
            name = I18n.exists((String)key) ? accessor.getBlock().getName() : ((pick2 = accessor.getPickedResult()) != null && !pick2.isEmpty() ? pick2.getHoverName() : Component.literal((String)key));
        }
        tooltip.add((Component)IThemeHelper.get().title(name));
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Component name = ObjectNameProvider.getEntityName(accessor.getEntity());
        tooltip.add((Component)IThemeHelper.get().title(name));
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof Nameable) {
            Block block;
            Nameable nameable = (Nameable)blockEntity;
            Component name = null;
            if (blockEntity instanceof ChestBlockEntity && (block = accessor.getBlock()) instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                MenuProvider menuProvider = accessor.getBlockState().getMenuProvider(accessor.getLevel(), accessor.getPosition());
                if (menuProvider != null) {
                    name = menuProvider.getDisplayName();
                }
            } else if (nameable.hasCustomName()) {
                name = nameable.getDisplayName();
            }
            if (name != null) {
                data.putString("givenName", Component.Serializer.toJson((Component)name));
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.CORE_OBJECT_NAME;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getDefaultPriority() {
        return -10100;
    }
}

