/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public enum ItemStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<Object, ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;

    public final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.getServerData().contains("JadeItemStorage")) {
            if (accessor.getServerData().getBoolean("Loot")) {
                tooltip.add((Component)Component.translatable((String)"jade.loot_not_generated"));
            } else if (accessor.getServerData().getBoolean("Locked")) {
                tooltip.add((Component)Component.translatable((String)"jade.locked"));
            }
            return;
        }
        Optional<IClientExtensionProvider> provider = Optional.ofNullable(ResourceLocation.tryParse((String)accessor.getServerData().getString("JadeItemStorageUid"))).map(WailaClientRegistration.instance().itemStorageProviders::get);
        if (provider.isEmpty()) {
            return;
        }
        List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeItemStorage", itemTag -> {
            ItemStack item = ItemStack.of((CompoundTag)itemTag);
            if (!item.isEmpty() && itemTag.contains("NewCount")) {
                item.setCount(itemTag.getInt("NewCount"));
            }
            return item;
        }));
        if (groups.isEmpty()) {
            return;
        }
        MutableBoolean showName = new MutableBoolean(true);
        int totalSize = 0;
        for (ClientViewGroup clientViewGroup : groups) {
            for (ItemView view : clientViewGroup.views) {
                if (view.amountText != null) {
                    showName.setFalse();
                }
                if (view.item.isEmpty()) continue;
                ++totalSize;
            }
        }
        if (showName.isTrue()) {
            showName.setValue(totalSize < PluginConfig.INSTANCE.getInt(Identifiers.MC_ITEM_STORAGE_SHOW_NAME_AMOUNT));
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            float progress;
            CompoundTag data;
            if (renderGroup) {
                theTooltip.add(new HorizontalLineElement());
                if (group.title != null) {
                    theTooltip.append(helper.text(group.title).scale(0.5f));
                    theTooltip.append(new HorizontalLineElement());
                }
            }
            if (group.views.isEmpty() && (data = group.extraData) != null && data.contains("Collecting", 99) && (progress = data.getFloat("Collecting")) < 1.0f) {
                MutableComponent component = Component.translatable((String)"jade.collectingItems");
                if (progress > 0.0f) {
                    component.append(" %s%%".formatted((int)(progress * 100.0f)));
                }
                theTooltip.add((Component)component);
            }
            int drawnCount = 0;
            int realSize = PluginConfig.INSTANCE.getInt(accessor.showDetails() ? Identifiers.MC_ITEM_STORAGE_DETAILED_AMOUNT : Identifiers.MC_ITEM_STORAGE_NORMAL_AMOUNT);
            realSize = Math.min(group.views.size(), realSize);
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < realSize; ++i) {
                ItemView itemView = (ItemView)group.views.get(i);
                ItemStack stack = itemView.item;
                if (stack.isEmpty()) continue;
                if (i > 0 && (showName.isTrue() || drawnCount >= PluginConfig.INSTANCE.getInt(Identifiers.MC_ITEM_STORAGE_ITEMS_PER_LINE))) {
                    theTooltip.add(elements);
                    theTooltip.setLineMargin(-1, Direction2D.DOWN, -1);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName.isTrue()) {
                    if (itemView.description != null) {
                        elements.add(helper.smallItem(stack));
                        elements.addAll(itemView.description);
                    } else {
                        elements.add(helper.smallItem(stack).clearCachedMessage());
                        elements.add(helper.text((Component)Component.literal((String)IDisplayHelper.get().humanReadableNumber(stack.getCount(), "", false, null)).append("\u00d7 ").append((Component)IDisplayHelper.get().stripColor(stack.getHoverName()))).message(null));
                    }
                } else if (itemView.amountText != null) {
                    elements.add(helper.item(stack, 1.0f, itemView.amountText));
                } else {
                    elements.add(helper.item(stack));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                theTooltip.add(elements);
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        CompoundTag tag = accessor.getServerData();
        Object target = accessor.getTarget();
        Player player = accessor.getPlayer();
        for (IServerExtensionProvider<Object, ItemStack> provider : WailaCommonRegistration.instance().itemStorageProviders.get(target)) {
            RandomizableContainer containerEntity;
            List groups = provider.getGroups(accessor, target);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                CompoundTag itemTag = new CompoundTag();
                int count = item.getCount();
                if (count > 64) {
                    item.setCount(1);
                }
                item.save(itemTag);
                if (count > 64) {
                    itemTag.putInt("NewCount", count);
                    item.setCount(count);
                }
                return itemTag;
            })) {
                tag.putString("JadeItemStorageUid", provider.getUid().toString());
                break;
            }
            if (target instanceof RandomizableContainer && (containerEntity = (RandomizableContainer)target).getLootTable() != null) {
                tag.putBoolean("Loot", true);
                break;
            }
            if (player.isCreative() || player.isSpectator() || !(target instanceof BaseContainerBlockEntity)) break;
            BaseContainerBlockEntity te = (BaseContainerBlockEntity)target;
            if (te.lockKey == LockCode.NO_LOCK) break;
            tag.putBoolean("Locked", true);
            break;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        if (accessor.getBlockEntity() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.putData(accessor);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor, Object target) {
        ItemCollector itemCollector;
        ContainerEntity containerEntity;
        RandomizableContainer te;
        if (target instanceof RandomizableContainer && (te = (RandomizableContainer)target).getLootTable() != null) {
            return List.of();
        }
        if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).getLootTable() != null) {
            return List.of();
        }
        Player player = accessor.getPlayer();
        if (!player.isCreative() && !player.isSpectator() && target instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity te2 = (BaseContainerBlockEntity)target;
            if (te2.lockKey != LockCode.NO_LOCK) {
                return List.of();
            }
        }
        if (target instanceof EnderChestBlockEntity) {
            PlayerEnderChestContainer inventory = player.getEnderChestInventory();
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator($ -> inventory, 0)).update(accessor, accessor.getLevel().getGameTime());
        }
        try {
            itemCollector = (ItemCollector)this.targetCache.get(target, () -> CommonProxy.createItemCollector(accessor, this.containerCache));
        }
        catch (ExecutionException e) {
            WailaExceptionHandler.handleErr(e, null, null);
            return null;
        }
        if (itemCollector == ItemCollector.EMPTY) {
            return null;
        }
        return itemCollector.update(accessor, accessor.getLevel().getGameTime());
    }

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, ItemView::new, null);
    }
}

