/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum ChiseledBookshelfProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    private static ItemStack getHitBook(BlockAccessor accessor) {
        if (!(accessor.getBlockEntity() instanceof ChiseledBookShelfBlockEntity)) {
            return ItemStack.EMPTY;
        }
        if (!accessor.getServerData().contains("Bookshelf")) {
            return ItemStack.EMPTY;
        }
        Optional optional = ChiseledBookShelfBlock.getRelativeHitCoordinatesForBlockFace((BlockHitResult)((BlockHitResult)accessor.getHitResult()), (Direction)((Direction)accessor.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
        if (optional.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int i = ChiseledBookShelfBlock.getHitSlot((Vec2)((Vec2)optional.get()));
        NonNullList items = NonNullList.withSize((int)((ChiseledBookShelfBlockEntity)accessor.getBlockEntity()).getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)accessor.getServerData().getCompound("Bookshelf"), (NonNullList)items);
        if (i >= items.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)items.get(i);
    }

    @Override
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.showDetails()) {
            return null;
        }
        ItemStack item = ChiseledBookshelfProvider.getHitBook(accessor);
        return item.isEmpty() ? null : IElementHelper.get().item(item);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.showDetails()) {
            return;
        }
        ItemStack item = ChiseledBookshelfProvider.getHitBook(accessor);
        if (item.isEmpty()) {
            return;
        }
        tooltip.remove(Identifiers.UNIVERSAL_ITEM_STORAGE);
        tooltip.add((Component)IDisplayHelper.get().stripColor(item.getHoverName()));
        if (item.getTag() != null && item.getTag().contains("StoredEnchantments")) {
            ArrayList list = Lists.newArrayList();
            ItemStack.appendEnchantmentNames((List)list, (ListTag)EnchantedBookItem.getEnchantments((ItemStack)item));
            tooltip.addAll(list);
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        ChiseledBookShelfBlockEntity be = (ChiseledBookShelfBlockEntity)accessor.getBlockEntity();
        if (!be.isEmpty()) {
            data.put("Bookshelf", (Tag)be.saveWithoutMetadata());
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_CHISELED_BOOKSHELF;
    }

    @Override
    public int getDefaultPriority() {
        return ItemStorageProvider.INSTANCE.getDefaultPriority() + 1;
    }
}

