/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum FurnaceProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!data.contains("progress")) {
            return;
        }
        int progress = data.getInt("progress");
        ListTag furnaceItems = data.getList("furnace", 10);
        NonNullList inventory = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        for (int i = 0; i < furnaceItems.size(); ++i) {
            inventory.set(i, (Object)ItemStack.of((CompoundTag)furnaceItems.getCompound(i)));
        }
        IElementHelper helper = IElementHelper.get();
        int total = data.getInt("total");
        tooltip.add(helper.item((ItemStack)inventory.get(0)));
        tooltip.append(helper.item((ItemStack)inventory.get(1)));
        tooltip.append(helper.spacer(4, 0));
        tooltip.append(helper.progress((float)progress / (float)total).translate(new Vec2(-2.0f, 0.0f)));
        tooltip.append(helper.item((ItemStack)inventory.get(2)));
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)accessor.getBlockEntity();
        if (furnace.isEmpty()) {
            return;
        }
        ListTag items = new ListTag();
        for (int i = 0; i < 3; ++i) {
            items.add((Object)furnace.getItem(i).save(new CompoundTag()));
        }
        data.put("furnace", (Tag)items);
        CompoundTag furnaceTag = furnace.saveWithoutMetadata();
        data.putInt("progress", furnaceTag.getInt("CookTime"));
        data.putInt("total", furnaceTag.getInt("CookTimeTotal"));
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_FURNACE;
    }
}

