/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import snownee.jade.JadeClient;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.ui.TextElement;
import snownee.jade.util.ModIdentification;

public enum ItemTooltipProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        ItemStack stack = ((ItemEntity)accessor.getEntity()).getItem();
        JadeClient.hideModName = true;
        ArrayList lines = Lists.newArrayList();
        stack.getTooltipLines(null, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().peek(component -> {
            MutableComponent mutable;
            if (component instanceof MutableComponent && (mutable = (MutableComponent)component).getStyle().getColor() != null) {
                mutable.setStyle(mutable.getStyle().withColor((TextColor)null));
            }
        }).map(Either::left).forEach(lines::add);
        JadeClient.hideModName = false;
        if (lines.isEmpty()) {
            return;
        }
        List<FormattedText> realLines = lines.stream().map($ -> $.left()).filter(Optional::isPresent).map(Optional::get).skip(1L).toList();
        String modName = ModIdentification.getModName(stack);
        Font font = Minecraft.getInstance().font;
        int maxWidth = 250;
        for (FormattedText text : realLines) {
            if (Objects.equals(ChatFormatting.stripFormatting((String)text.getString()), modName)) continue;
            int width = font.width(text);
            if (width > maxWidth) {
                tooltip.add((Component)Component.literal((String)(font.substrByWidth(text, maxWidth - 5).getString() + "..")));
                continue;
            }
            tooltip.add(new TextElement(text));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_ITEM_TOOLTIP;
    }
}

