/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;

public enum JukeboxProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        if (((Boolean)state.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue() && accessor.getServerData().contains("Record")) {
            try {
                Component name;
                ItemStack stack = ItemStack.of((CompoundTag)accessor.getServerData().getCompound("Record"));
                Item item = stack.getItem();
                if (item instanceof RecordItem) {
                    RecordItem record = (RecordItem)item;
                    name = record.getDisplayName();
                } else {
                    name = stack.getHoverName();
                }
                tooltip.add((Component)Component.translatable((String)"record.nowPlaying", (Object[])new Object[]{IDisplayHelper.get().stripColor(name)}));
            }
            catch (Exception e) {
                Jade.LOGGER.error("", (Throwable)e);
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.empty"));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        ItemStack stack = ((JukeboxBlockEntity)accessor.getBlockEntity()).getTheItem();
        if (!stack.isEmpty()) {
            data.put("Record", (Tag)stack.save(new CompoundTag()));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_JUKEBOX;
    }
}

