/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;

public enum LecternProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack stack;
        BlockState state = accessor.getBlockState();
        if (((Boolean)state.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue() && accessor.getServerData().contains("Book") && !(stack = ItemStack.of((CompoundTag)accessor.getServerData().getCompound("Book"))).isEmpty()) {
            IElementHelper helper = IElementHelper.get();
            tooltip.add(helper.smallItem(stack));
            tooltip.append(helper.text((Component)IDisplayHelper.get().stripColor(stack.getHoverName())).message(I18n.get((String)"narration.jade.bookName", (Object[])new Object[]{stack.getHoverName().getString()})));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        ItemStack stack = ((LecternBlockEntity)accessor.getBlockEntity()).getBook();
        if (!stack.isEmpty() && (stack.hasCustomHoverName() || stack.getItem() != Items.WRITABLE_BOOK)) {
            data.put("Book", (Tag)stack.save(new CompoundTag()));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_LECTERN;
    }
}

