/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum RedstoneProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.getBlock();
        IThemeHelper t = IThemeHelper.get();
        if (block instanceof LeverBlock) {
            MutableComponent info = (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? t.success(Component.translatable((String)"tooltip.jade.state_on")) : t.danger(Component.translatable((String)"tooltip.jade.state_off"));
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.state", (Object[])new Object[]{info}));
            return;
        }
        if (block == Blocks.REPEATER) {
            int delay = (Integer)state.getValue((Property)BlockStateProperties.DELAY);
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.delay", (Object[])new Object[]{t.info(delay)}));
            return;
        }
        if (block == Blocks.COMPARATOR) {
            ComparatorMode mode = (ComparatorMode)state.getValue((Property)BlockStateProperties.MODE_COMPARATOR);
            MutableComponent modeInfo = t.info(Component.translatable((String)("tooltip.jade.mode_" + (mode == ComparatorMode.COMPARE ? "comparator" : "subtractor"))));
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.mode", (Object[])new Object[]{modeInfo}));
            if (accessor.getServerData().contains("Signal")) {
                tooltip.add((Component)Component.translatable((String)"tooltip.jade.power", (Object[])new Object[]{t.info(accessor.getServerData().getInt("Signal"))}));
            }
            return;
        }
        if (block instanceof CalibratedSculkSensorBlock && accessor.getServerData().contains("Signal")) {
            tooltip.add((Component)Component.translatable((String)"jade.input_signal", (Object[])new Object[]{t.info(accessor.getServerData().getInt("Signal"))}));
        }
        if (state.hasProperty((Property)BlockStateProperties.POWER)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.jade.power", (Object[])new Object[]{t.info(state.getValue((Property)BlockStateProperties.POWER))}));
        }
        if (state.getBlock() instanceof HopperBlock && accessor.getServerData().contains("HopperLocked")) {
            tooltip.add((Component)t.danger(Component.translatable((String)"jade.hopper.locked")));
        }
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity comparator = (ComparatorBlockEntity)blockEntity;
            data.putInt("Signal", comparator.getOutputSignal());
        } else if (blockEntity instanceof HopperBlockEntity) {
            BlockState state = accessor.getBlockState();
            if (state.hasProperty((Property)BlockStateProperties.ENABLED) && !((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                data.putBoolean("HopperLocked", true);
            }
        } else if (blockEntity instanceof CalibratedSculkSensorBlockEntity) {
            Direction direction = ((Direction)accessor.getBlockState().getValue((Property)CalibratedSculkSensorBlock.FACING)).getOpposite();
            int signal = accessor.getLevel().getSignal(accessor.getPosition().relative(direction), direction);
            data.putInt("Signal", signal);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_REDSTONE;
    }
}

