/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum StatusEffectsProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = mobEffectInstance.getEffect().getDisplayName().copy();
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9) {
            mutableComponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (mobEffectInstance.getAmplifier() + 1))));
        }
        return mutableComponent;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().contains("StatusEffects")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        ITooltip box = helper.tooltip();
        ListTag list = accessor.getServerData().getList("StatusEffects", 10);
        Component[] lines = new Component[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            String duration;
            CompoundTag compound = list.getCompound(i);
            MutableComponent name = Component.Serializer.fromJsonLenient((String)compound.getString("Name"));
            if (name == null) continue;
            if (compound.getBoolean("Infinite")) {
                duration = I18n.get((String)"effect.duration.infinite", (Object[])new Object[0]);
            } else {
                float tickrate = accessor.getLevel().tickRateManager().tickrate();
                duration = StringUtil.formatTickDuration((int)compound.getInt("Duration"), (float)tickrate);
            }
            MutableComponent s = Component.translatable((String)"jade.potion", (Object[])new Object[]{name, duration});
            IThemeHelper t = IThemeHelper.get();
            box.add((Component)(compound.getBoolean("Bad") ? t.danger(s) : t.success(s)));
        }
        tooltip.add(helper.box(box, BoxStyle.getNestedBox()));
    }

    @Override
    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        LivingEntity living = (LivingEntity)accessor.getEntity();
        Collection effects = living.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (MobEffectInstance effect : effects) {
            CompoundTag compound = new CompoundTag();
            compound.putString("Name", Component.Serializer.toJson((Component)StatusEffectsProvider.getEffectName(effect)));
            if (effect.isInfiniteDuration()) {
                compound.putBoolean("Infinite", true);
            } else {
                compound.putInt("Duration", effect.getDuration());
            }
            compound.putBoolean("Bad", effect.getEffect().getCategory() == MobEffectCategory.HARMFUL);
            list.add((Object)compound);
        }
        tag.put("StatusEffects", (Tag)list);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_POTION_EFFECTS;
    }
}

