/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.CommonProxy;

public enum TotalEnchantmentPowerProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Level world = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        float power = 0.0f;
        for (BlockPos blockpos : EnchantmentTableBlock.BOOKSHELF_OFFSETS) {
            if (!EnchantmentTableBlock.isValidBookShelf((Level)world, (BlockPos)pos, (BlockPos)blockpos)) continue;
            power += TotalEnchantmentPowerProvider.getPower(world, pos.offset((Vec3i)blockpos));
        }
        if (power > 0.0f) {
            tooltip.add((Component)Component.translatable((String)"jade.ench_power", (Object[])new Object[]{IThemeHelper.get().info(DisplayHelper.dfCommas.format(power))}));
        }
    }

    public static float getPower(Level world, BlockPos pos) {
        return CommonProxy.getEnchantPowerBonus(world.getBlockState(pos), world, pos);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_TOTAL_ENCHANTMENT_POWER;
    }

    @Override
    public int getDefaultPriority() {
        return -400;
    }
}

