/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.FluidTextHelper;

public class FluidView {
    public static final Component EMPTY_FLUID = Component.translatable((String)"jade.fluid.empty");
    public IElement overlay;
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public Component fluidName;
    @Nullable
    public Component overrideText;

    public FluidView(IElement overlay) {
        this.overlay = overlay;
        Objects.requireNonNull(overlay);
    }

    @Nullable
    public static FluidView readDefault(CompoundTag tag) {
        long capacity = tag.getLong("capacity");
        if (capacity <= 0L) {
            return null;
        }
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(tag.getString("fluid")));
        CompoundTag nbt = tag.contains("tag") ? tag.getCompound("tag") : null;
        long amount = tag.getLong("amount");
        JadeFluidObject fluidObject = JadeFluidObject.of(fluid, amount, nbt);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluidObject));
        fluidView.fluidName = CommonProxy.getFluidName(fluidObject);
        fluidView.current = FluidTextHelper.getUnicodeMillibuckets(amount, true);
        fluidView.max = FluidTextHelper.getUnicodeMillibuckets(capacity, true);
        fluidView.ratio = (float)((double)amount / (double)capacity);
        if (fluidObject.getType().isSame(Fluids.EMPTY)) {
            fluidView.overrideText = Component.translatable((String)"jade.fluid", (Object[])new Object[]{EMPTY_FLUID, Component.literal((String)fluidView.max).withStyle(ChatFormatting.GRAY)});
        }
        return fluidView;
    }

    public static CompoundTag writeDefault(JadeFluidObject fluidObject, long capacity) {
        CompoundTag tag = new CompoundTag();
        if (capacity <= 0L) {
            return tag;
        }
        tag.putString("fluid", BuiltInRegistries.FLUID.getKey((Object)fluidObject.getType()).toString());
        tag.putLong("amount", fluidObject.getAmount());
        tag.putLong("capacity", capacity);
        if (fluidObject.getTag() != null) {
            tag.put("tag", (Tag)fluidObject.getTag());
        }
        return tag;
    }
}

