/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.JadeFont;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.SmoothChasingValue;

public class HomeConfigScreen
extends Screen {
    private final RandomSource random = RandomSource.create((long)42L);
    private final Screen parent;
    private final SmoothChasingValue titleY;
    private final SmoothChasingValue creditHover;
    private final Component credit;
    private final List<TextParticle> particles = Lists.newArrayList();
    private final List<TextParticle> pendingParticles = Lists.newArrayList();
    private int creditWidth;
    private boolean hovered;
    private float ticks;
    private byte festival;
    private float nextParticleIn;

    public HomeConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"gui.jade.configuration"));
        this.parent = parent;
        this.titleY = new SmoothChasingValue().start(8.0f).target(32.0f).withSpeed(0.1f);
        this.creditHover = new SmoothChasingValue();
        LocalDate now = LocalDate.now();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        if (month == 12 && day >= 24 && day <= 26) {
            this.festival = 1;
        } else if (month == 6 && day == 28) {
            this.festival = (byte)2;
        } else if (month <= 2 && HomeConfigScreen.isLunarNewYear(now)) {
            this.festival = (byte)99;
        }
        this.credit = Component.translatable((String)"gui.jade.by", (Object[])new Object[]{Component.literal((String)"\u2764").withStyle(ChatFormatting.RED)}).withStyle(s -> {
            if (this.festival != 0 && this.festival != 1) {
                s = s.withColor(15852452);
            }
            return s;
        });
    }

    private static boolean isLunarNewYear(LocalDate now) {
        int newYearMonthAndDay;
        int year = now.getYear();
        switch (year) {
            case 2025: {
                int n = 129;
                break;
            }
            case 2026: {
                int n = 217;
                break;
            }
            case 2027: {
                int n = 206;
                break;
            }
            case 2028: {
                int n = 126;
                break;
            }
            case 2029: {
                int n = 213;
                break;
            }
            case 2030: {
                int n = 203;
                break;
            }
            case 2031: {
                int n = 123;
                break;
            }
            case 2032: {
                int n = 211;
                break;
            }
            case 2033: {
                int n = 131;
                break;
            }
            case 2034: {
                int n = 219;
                break;
            }
            case 2035: {
                int n = 208;
                break;
            }
            case 2036: {
                int n = 128;
                break;
            }
            case 2037: {
                int n = 215;
                break;
            }
            case 2038: {
                int n = 204;
                break;
            }
            case 2039: {
                int n = 124;
                break;
            }
            case 2040: {
                int n = 212;
                break;
            }
            case 2041: {
                int n = 201;
                break;
            }
            case 2042: {
                int n = 122;
                break;
            }
            case 2043: {
                int n = 210;
                break;
            }
            default: {
                int n = newYearMonthAndDay = 0;
            }
        }
        if (newYearMonthAndDay == 0) {
            return false;
        }
        int newYearMonth = newYearMonthAndDay / 100;
        int newYearDay = newYearMonthAndDay % 100;
        LocalDate newYearDate = LocalDate.of(year, newYearMonth, newYearDay);
        int newYearDayOfYear = newYearDate.getDayOfYear();
        int dayOfYear = now.getDayOfYear();
        return dayOfYear >= newYearDayOfYear - 1 && dayOfYear <= newYearDayOfYear + 2;
    }

    protected void init() {
        Objects.requireNonNull(this.minecraft);
        this.particles.clear();
        this.creditWidth = this.font.width((FormattedText)this.credit);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.jade.jade_settings"), w -> this.minecraft.setScreen((Screen)new WailaConfigScreen(this))).bounds(this.width / 2 - 105, this.height / 2 - 10, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.jade.plugin_settings"), w -> this.minecraft.setScreen((Screen)new PluginsConfigScreen(this))).bounds(this.width / 2 + 5, this.height / 2 - 10, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, w -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 20, 100, 20).build());
    }

    public void onClose() {
        Jade.CONFIG.save();
        PluginConfig.INSTANCE.save();
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean hover;
        float scaledY;
        float scaledX;
        Objects.requireNonNull(this.minecraft);
        this.ticks += partialTicks;
        if (this.ticks > this.nextParticleIn) {
            if (this.festival == 3) {
                this.nextParticleIn = this.ticks + 1.0f;
                if (this.pendingParticles.isEmpty()) {
                    this.festival3populateNew();
                }
                TextParticle particle = this.pendingParticles.remove(0);
                particle.x = mouseX - 5;
                particle.y = mouseY;
                this.particles.add(particle);
            } else if (this.festival == 1) {
                this.nextParticleIn = this.ticks + 10.0f + this.random.nextFloat() * 10.0f;
                int color = Mth.color((float)(1.0f - this.random.nextFloat() * 0.6f), (float)1.0f, (float)1.0f);
                int x = this.random.nextIntBetweenInclusive(40, this.width + 100);
                TextParticle particle = new TextParticle("\u2744", x, -20.0f, -0.3f, 0.5f, color |= this.random.nextInt(80) + 40 << 24, 2.0f + this.random.nextFloat());
                particle.gravity = 0.0f;
                this.particles.add(particle);
            }
        }
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        boolean smallUI = this.minecraft.getWindow().getGuiScale() < 3.0;
        int left = this.width / 2 - 105;
        int top = this.height / 4 - 20;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)left, (float)top, 0.0f);
        float scale = smallUI ? 2.0f : 1.5f;
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.drawString(this.font, ModIdentification.getModName("jade").orElse("Jade"), 0, 0, 0xFFFFFF);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        this.titleY.tick(partialTicks);
        String desc2 = I18n.get((String)"gui.jade.configuration.desc2", (Object[])new Object[0]);
        if (desc2.isEmpty()) {
            guiGraphics.pose().popPose();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)left, (float)top, 0.0f);
            scaledX = mouseX - left;
            scaledY = mouseY - top;
        } else {
            scaledX = (float)(mouseX - left) / scale * 2.0f;
            scaledY = (float)(mouseY - top) / scale * 2.0f;
        }
        this.drawFancyTitle(guiGraphics, I18n.get((String)"gui.jade.configuration.desc1", (Object[])new Object[0]), Math.min(this.titleY.value, 20.0f), 20.0f, scaledX, scaledY);
        if (!desc2.isEmpty()) {
            this.drawFancyTitle(guiGraphics, desc2, Math.min(this.titleY.value + 3.0f, 32.0f), 32.0f, scaledX, scaledY);
        }
        guiGraphics.pose().popPose();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int creditX = (int)((float)this.width * 0.5f - (float)this.creditWidth * 0.5f);
        int creditY = (int)((float)this.height * 0.9f - 5.0f);
        boolean bl = hover = mouseX >= creditX && mouseX < creditX + this.creditWidth && mouseY >= creditY && mouseY < creditY + 10;
        if (!this.hovered && hover) {
            this.creditHover.target(1.0f);
        } else if (!hover) {
            this.creditHover.target(0.0f);
        } else if ((double)this.creditHover.value > 0.5) {
            this.creditHover.target(0.0f);
            IntArrayList colors = new IntArrayList();
            String text = "\u2744";
            if (this.festival == 2) {
                this.festival = (byte)3;
            } else if (this.festival == 99) {
                for (i = 0; i < 11; ++i) {
                    colors.add(this.random.nextBoolean() ? 0xA80000 : 12589056);
                }
                text = "\u2710";
            } else {
                for (i = 0; i < 11; ++i) {
                    colors.add(Mth.color((float)(1.0f - this.random.nextFloat() * 0.6f), (float)1.0f, (float)1.0f));
                }
            }
            IntListIterator intListIterator = colors.iterator();
            while (intListIterator.hasNext()) {
                int color = (Integer)intListIterator.next();
                int ox = this.random.nextIntBetweenInclusive(-this.creditWidth / 2, this.creditWidth / 2);
                float x = (float)this.width * 0.5f + (float)ox;
                float y = creditY + this.random.nextInt(10);
                float dx = (float)ox * 0.08f;
                float dy = -5.0f - this.random.nextFloat() * 3.0f;
                TextParticle particle = new TextParticle(text, x, y, dx, dy, color, 0.75f + this.random.nextFloat() * 0.5f);
                this.particles.add(particle);
                if (this.festival != 99) continue;
                particle.age = 8.0f + this.random.nextFloat() * 5.0f;
            }
        }
        this.creditHover.tick(partialTicks);
        this.creditHover.value = Math.min(0.6f, this.creditHover.value);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.width * 0.5f, (float)creditY, 0.0f);
        scale = 1.0f + this.creditHover.value * 0.2f;
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.pose().translate((float)this.creditWidth * -0.5f, 0.0f, 0.0f);
        guiGraphics.drawString(this.font, this.credit, 0, 0, 0x55FFFFFF);
        guiGraphics.pose().popPose();
        this.hovered = hover;
        this.particles.removeIf(p -> {
            p.tick(partialTicks);
            if (p.y > (float)(this.height + 20)) {
                return true;
            }
            p.render(guiGraphics, this.font);
            return false;
        });
    }

    private void festival3populateNew() {
        IntArrayList colors = new IntArrayList();
        String text = this.random.nextBoolean() ? "UwU" : "OwO";
        switch (this.random.nextInt(7)) {
            case 0: {
                colors.add(14942979);
                colors.add(16747520);
                colors.add(16772352);
                colors.add(32806);
                colors.add(7547266);
                colors.add(7547266);
                break;
            }
            case 1: {
                colors.add(6016762);
                colors.add(16099768);
                colors.add(0xFFFFFF);
                colors.add(16099768);
                colors.add(6016762);
                break;
            }
            case 2: {
                colors.add(14025328);
                colors.add(14025328);
                colors.add(10178454);
                colors.add(14504);
                colors.add(14504);
                break;
            }
            case 3: {
                colors.add(16720268);
                colors.add(16720268);
                colors.add(16766976);
                colors.add(16766976);
                colors.add(2208255);
                colors.add(2208255);
                break;
            }
            case 4: {
                colors.add(0);
                colors.add(0xA3A3A3);
                colors.add(0xFFFFFF);
                colors.add(0x800080);
                break;
            }
            case 5: {
                colors.add(16742052);
                colors.add(0xFFFFFF);
                colors.add(12587479);
                colors.add(0);
                colors.add(3095742);
                break;
            }
            case 6: {
                colors.add(16577588);
                colors.add(0xFFFFFF);
                colors.add(10246609);
                colors.add(0x2C2C2C);
            }
        }
        int ox = this.random.nextIntBetweenInclusive(-this.creditWidth / 2, this.creditWidth / 2);
        float dx = (float)ox * 0.08f;
        float dy = -5.0f - this.random.nextFloat() * 3.0f;
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            for (int i = 0; i < 5; ++i) {
                TextParticle particle = new TextParticle(text, 0.0f, 0.0f, dx, dy, color, 1.0f);
                this.pendingParticles.add(particle);
            }
        }
    }

    private void drawFancyTitle(GuiGraphics guiGraphics, String text, float y, float expectY, float mouseX, float mouseY) {
        float distY = Math.abs(y - expectY);
        if (distY >= 9.0f) {
            return;
        }
        int color = IWailaConfig.IConfigOverlay.applyAlpha(0xAAAAAA, 1.0f - distY / 10.0f);
        ((JadeFont)this.font).jade$setGlint((this.ticks - y / 5.0f) % 90.0f / 45.0f * (float)this.width, mouseX);
        ((JadeFont)this.font).jade$setGlintStrength(1.0f, 1.0f - Mth.clamp((float)(Math.abs(mouseY - y) / 20.0f), (float)0.0f, (float)1.0f));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, y, 0.0f);
        guiGraphics.drawString(this.font, text, 0, 0, color);
        guiGraphics.pose().popPose();
        ((JadeFont)this.font).jade$setGlint(Float.NaN, Float.NaN);
    }

    private class TextParticle {
        private float age;
        private String text;
        private float x;
        private float y;
        private float motionX;
        private float motionY;
        private int color;
        private float scale;
        private float gravity = 0.98f;

        public TextParticle(String text, float x, float y, float motionX, float motionY, int color, float scale) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.motionX = motionX;
            this.motionY = motionY;
            this.color = color;
            this.scale = scale;
        }

        private void tick(float partialTicks) {
            this.x += this.motionX * partialTicks;
            this.y += this.motionY * partialTicks;
            this.motionY += this.gravity * partialTicks;
            if (HomeConfigScreen.this.festival == 99) {
                boolean greaterThanZero = this.age > 0.0f;
                this.age -= partialTicks;
                if (greaterThanZero && this.age <= 0.0f) {
                    this.text = HomeConfigScreen.this.random.nextBoolean() ? "\u2734" : "\u2733";
                    this.color = HomeConfigScreen.this.random.nextBoolean() ? 16765991 : 15778837;
                    Objects.requireNonNull(HomeConfigScreen.this.minecraft);
                    HomeConfigScreen.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)(HomeConfigScreen.this.random.nextBoolean() ? SoundEvents.FIREWORK_ROCKET_BLAST : SoundEvents.FIREWORK_ROCKET_LARGE_BLAST), (float)0.7f));
                }
            } else if (HomeConfigScreen.this.festival == 1) {
                this.age -= partialTicks;
            }
        }

        private void render(GuiGraphics guiGraphics, Font font) {
            if (HomeConfigScreen.this.festival == 99 && this.age < -4.0f) {
                return;
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(this.x, this.y, 0.0f);
            guiGraphics.pose().scale(this.scale, this.scale, this.scale);
            if (HomeConfigScreen.this.festival == 1) {
                guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(this.age));
            }
            guiGraphics.drawString(font, this.text, 0, 0, this.color);
            guiGraphics.pose().popPose();
        }
    }
}

