/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.overlay.OverlayRenderer;

public abstract class PreviewOptionsScreen
extends BaseOptionsScreen {
    public boolean adjustingPosition;
    private boolean adjustDragging;
    private double dragOffsetX;
    private double dragOffsetY;

    public PreviewOptionsScreen(Screen parent, Component title) {
        super(parent, title);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAdjustingPosition() {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof PreviewOptionsScreen)) return false;
        PreviewOptionsScreen screen2 = (PreviewOptionsScreen)screen;
        if (!screen2.adjustingPosition) return false;
        return true;
    }

    private static float calculateAnchor(float center, float size) {
        float anchor = center / size;
        if (anchor < 0.25f) {
            return 0.0f;
        }
        if (anchor < 0.75f) {
            return 0.5f;
        }
        return 1.0f;
    }

    private static float maybeSnap(float value) {
        if (!Screen.hasControlDown() && value > 0.475f && value < 0.525f) {
            return 0.5f;
        }
        return value;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.minecraft);
        super.init();
        if (this.minecraft.level != null) {
            CycleButton previewButton = CycleButton.booleanBuilder((Component)OptionsList.OPTION_ON, (Component)OptionsList.OPTION_OFF).create(10, this.saveButton.getY(), 85, 20, (Component)Component.translatable((String)"gui.jade.preview"), (button, value) -> {
                Jade.CONFIG.get().getGeneral().previewOverlay = value;
                this.saver.run();
            });
            previewButton.setValue((Object)Jade.CONFIG.get().getGeneral().previewOverlay);
            this.addRenderableWidget((GuiEventListener)previewButton);
        }
    }

    public boolean forcePreviewOverlay() {
        Objects.requireNonNull(this.minecraft);
        if (this.adjustingPosition) {
            return true;
        }
        if (!this.isDragging() || this.options == null) {
            return false;
        }
        OptionsList.Entry entry = (OptionsList.Entry)this.options.getSelected();
        if (entry == null || entry.getFirstWidget() == null) {
            return false;
        }
        return this.options.forcePreview.contains((Object)entry);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int p_94697_) {
        if (this.adjustingPosition) {
            Objects.requireNonNull(this.minecraft);
            Rect2i rect = OverlayRenderer.rect.expectedRect;
            if (rect.contains((int)mouseX, (int)mouseY)) {
                this.setDragging(true);
                this.adjustDragging = true;
                float centerX = (float)rect.getX() + (float)rect.getWidth() / 2.0f;
                float centerY = (float)rect.getY() + (float)rect.getHeight() / 2.0f;
                this.dragOffsetX = mouseX - (double)centerX;
                this.dragOffsetY = mouseY - (double)centerY;
                return true;
            }
            this.adjustingPosition = false;
            this.adjustDragging = false;
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, p_94697_);
    }

    public boolean mouseReleased(double d, double e, int i) {
        if (this.adjustingPosition) {
            this.setDragging(false);
            this.adjustDragging = false;
            return true;
        }
        return super.mouseReleased(d, e, i);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.adjustingPosition) {
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public boolean keyReleased(int i, int j, int k) {
        Objects.requireNonNull(this.minecraft);
        if (this.adjustingPosition) {
            if (i == 256) {
                this.adjustingPosition = false;
                this.adjustDragging = false;
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return true;
        }
        return super.keyReleased(i, j, k);
    }

    public boolean mouseDragged(double d, double e, int i, double f, double g) {
        if (this.adjustingPosition && this.adjustDragging) {
            float centerX = (float)d - (float)this.dragOffsetX;
            float centerY = (float)e - (float)this.dragOffsetY;
            float anchorX = PreviewOptionsScreen.calculateAnchor(centerX, this.width);
            float anchorY = PreviewOptionsScreen.calculateAnchor(centerY, this.height);
            Rect2i rect = OverlayRenderer.rect.expectedRect;
            float posX = (centerX + (float)rect.getWidth() * (anchorX - 0.5f)) / (float)this.width;
            float posY = 1.0f - (centerY + (float)rect.getHeight() * (anchorY - 0.5f)) / (float)this.height;
            IWailaConfig.IConfigOverlay config = IWailaConfig.get().getOverlay();
            config.setOverlayPosX(config.tryFlip(PreviewOptionsScreen.maybeSnap(posX)));
            config.setOverlayPosY(PreviewOptionsScreen.maybeSnap(posY));
            config.setAnchorX(config.tryFlip(anchorX));
            config.setAnchorY(anchorY);
            return true;
        }
        return super.mouseDragged(d, e, i, f, g);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.adjustingPosition) {
            guiGraphics.fill(0, 0, this.width, this.height, 50, -2136298838);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 50.0f);
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"config.jade.overlay_pos.exit"), this.width / 2, this.height / 2 - 7, 0xFFFFFF);
            guiGraphics.pose().popPose();
            IWailaConfig.IConfigOverlay config = IWailaConfig.get().getOverlay();
            Rect2i rect = OverlayRenderer.rect.expectedRect;
            if (IWailaConfig.get().getGeneral().isDebug()) {
                int anchorX = (int)((float)rect.getX() + (float)rect.getWidth() * config.getAnchorX());
                int anchorY = (int)((float)rect.getY() + (float)rect.getHeight() * config.getAnchorY());
                guiGraphics.fill(anchorX - 2, anchorY - 2, anchorX + 1, anchorY + 1, 1000, -65536);
            }
            if (config.getOverlayPosX() == 0.5f) {
                guiGraphics.fill(this.width / 2, rect.getY() - 5, this.width / 2 + 1, rect.getY() + rect.getHeight() + 4, 1000, -16776961);
            }
            if (config.getOverlayPosY() == 0.5f) {
                guiGraphics.fill(rect.getX() - 5, this.height / 2, rect.getX() + rect.getWidth() + 4, this.height / 2 + 1, 1000, -16776961);
            }
            this.deferredTooltipRendering = null;
        }
    }
}

