/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.core.CorePlugin;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public class WailaConfigScreen
extends PreviewOptionsScreen {
    private OptionValue<Boolean> squareEntry;
    private OptionValue<Float> opacityEntry;

    public WailaConfigScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"gui.jade.jade_settings"));
        this.saver = Jade.CONFIG::save;
        ImmutableMap.Builder keyMapBuilder = ImmutableMap.builder();
        for (KeyMapping keyMapping : Minecraft.getInstance().options.keyMappings) {
            if (!JadeClient.openConfig.getCategory().equals(keyMapping.getCategory())) continue;
            keyMapBuilder.put((Object)keyMapping, (Object)ClientProxy.getBoundKeyOf(keyMapping));
        }
        ImmutableMap keyMap = keyMapBuilder.build();
        this.canceller = () -> {
            Jade.CONFIG.invalidate();
            keyMap.forEach(KeyMapping::setKey);
            Minecraft.getInstance().options.save();
        };
    }

    public static OptionsList.Entry editBlocklist(OptionsList.Entry entry, String fileName, Runnable defaultCreator) {
        entry.getFirstWidget().setWidth(79);
        MutableComponent tooltip = Component.translatable((String)"config.jade.edit_blocklist");
        entry.addWidget((AbstractWidget)Button.builder((Component)Component.literal((String)"\u2630"), b -> {
            File file = new File(CommonProxy.getConfigDirectory(), "jade/%s.json".formatted(fileName));
            if (!file.exists()) {
                defaultCreator.run();
            }
            Util.getPlatform().openFile(file);
        }).size(20, 20).tooltip(Tooltip.create((Component)tooltip)).createNarration($ -> tooltip).build(), 80);
        return entry;
    }

    @Override
    public OptionsList createOptions() {
        Objects.requireNonNull(this.minecraft);
        OptionsList options = new OptionsList(this, this.minecraft, this.width - 120, this.height - 32, 0, 26, Jade.CONFIG::save);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        options.title("general");
        if (CommonProxy.isDevEnv()) {
            options.choices("debug_mode", general.isDebug(), general::setDebug);
        }
        options.choices("display_tooltip", general.shouldDisplayTooltip(), general::setDisplayTooltip);
        OptionValue<Boolean> entry = options.choices("display_entities", general.getDisplayEntities(), general::setDisplayEntities);
        WailaConfigScreen.editBlocklist(entry, "hide-entities", () -> CorePlugin.createBlockBlocklist().get());
        options.choices("display_bosses", general.getDisplayBosses(), general::setDisplayBosses).parent(entry);
        entry = options.choices("display_blocks", general.getDisplayBlocks(), general::setDisplayBlocks);
        WailaConfigScreen.editBlocklist(entry, "hide-blocks", () -> CorePlugin.createBlockBlocklist().get());
        options.choices("display_fluids", general.getDisplayFluids(), general::setDisplayFluids).parent(entry);
        options.choices("display_mode", general.getDisplayMode(), general::setDisplayMode, builder -> builder.withTooltip(mode -> {
            String key = "display_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + "_desc";
            if (mode == IWailaConfig.DisplayMode.LITE && "fabric".equals(CommonProxy.getPlatformIdentifier())) {
                key = key + ".fabric";
            }
            return Tooltip.create((Component)OptionsList.Entry.makeTitle(key));
        }));
        OptionValue<Boolean> value = options.choices("item_mod_name", general.showItemModNameTooltip(), general::setItemModNameTooltip);
        if (!WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.isEmpty()) {
            value.setDisabled(true);
            value.appendDescription(I18n.get((String)"gui.jade.disabled_by_mods", (Object[])new Object[0]));
            WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.forEach(value::appendDescription);
            if (value.getFirstWidget() != null && value.getDescription() != null) {
                value.getFirstWidget().setTooltip(Tooltip.create((Component)Component.literal((String)value.getDescription())));
            }
        }
        options.choices("hide_from_debug", general.shouldHideFromDebug(), general::setHideFromDebug);
        options.choices("hide_from_tab_list", general.shouldHideFromTabList(), general::setHideFromTabList);
        options.choices("boss_bar_overlap", general.getBossBarOverlapMode(), general::setBossBarOverlapMode);
        options.slider("reach_distance", general.getReachDistance(), general::setReachDistance, 0.0f, 20.0f, f -> (float)Mth.floor((float)(f * 2.0f)) / 2.0f);
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        options.title("overlay");
        options.choices("overlay_theme", overlay.getTheme().id, IThemeHelper.get().getThemes().stream().filter($ -> !$.hidden).map($ -> $.id).toList(), id -> {
            if (Objects.equals(id, overlay.getTheme().id)) {
                return;
            }
            overlay.applyTheme((ResourceLocation)id);
            Theme theme = overlay.getTheme();
            if (theme.changeRoundCorner != null) {
                this.squareEntry.setValue(theme.changeRoundCorner);
            }
            if (theme.changeOpacity != 0.0f) {
                this.opacityEntry.setValue(Float.valueOf(theme.changeOpacity));
            }
        }, id -> Component.translatable((String)Util.makeDescriptionId((String)"jade.theme", (ResourceLocation)id)));
        this.squareEntry = options.choices("overlay_square", overlay.getSquare(), overlay::setSquare);
        this.opacityEntry = options.slider("overlay_alpha", overlay.getAlpha(), overlay::setAlpha);
        options.forcePreview.add(options.slider("overlay_scale", overlay.getOverlayScale(), overlay::setOverlayScale, 0.2f, 2.0f, FloatUnaryOperator.identity()));
        MutableComponent adjust = Component.translatable((String)OptionsList.Entry.makeKey("overlay_pos.adjust"));
        options.add(new OptionButton((Component)Component.translatable((String)OptionsList.Entry.makeKey("overlay_pos")), Button.builder((Component)adjust, w -> {
            this.adjustingPosition = true;
        }).size(100, 20).build()));
        options.choices("display_item", overlay.getIconMode(), overlay::setIconMode);
        options.choices("animation", overlay.getAnimation(), overlay::setAnimation);
        options.title("key_binds");
        options.keybind(JadeClient.openConfig);
        options.keybind(JadeClient.showOverlay);
        options.keybind(JadeClient.toggleLiquid);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            options.keybind(JadeClient.showRecipes);
            options.keybind(JadeClient.showUses);
        }
        options.keybind(JadeClient.narrate);
        options.keybind(JadeClient.showDetails);
        options.title("accessibility");
        options.choices("flip_main_hand", overlay.getFlipMainHand(), overlay::setFlipMainHand);
        options.choices("tts_mode", general.getTTSMode(), general::setTTSMode);
        options.title("danger_zone").withStyle(ChatFormatting.RED);
        MutableComponent reset = Component.translatable((String)"controls.reset").withStyle(ChatFormatting.RED);
        MutableComponent title = Component.translatable((String)OptionsList.Entry.makeKey("reset_settings")).withStyle(ChatFormatting.RED);
        options.add(new OptionButton((Component)title, Button.builder((Component)reset, arg_0 -> this.lambda$createOptions$14((Component)title, (Component)reset, arg_0)).size(100, 20).build()));
        return options;
    }

    private /* synthetic */ void lambda$createOptions$14(Component title, Component reset, Button w) {
        this.minecraft.setScreen((Screen)new ConfirmScreen(bl -> {
            if (bl) {
                for (KeyMapping keyMapping : this.minecraft.options.keyMappings) {
                    if (!JadeClient.openConfig.getCategory().equals(keyMapping.getCategory())) continue;
                    keyMapping.setKey(keyMapping.getDefaultKey());
                }
                this.minecraft.options.save();
                try {
                    int themesHash = Jade.CONFIG.get().getOverlay().themesHash;
                    Preconditions.checkState((boolean)Jade.CONFIG.getFile().delete());
                    Preconditions.checkState((boolean)PluginConfig.INSTANCE.getFile().delete());
                    Jade.CONFIG.invalidate();
                    Jade.CONFIG.get().getOverlay().themesHash = themesHash;
                    Jade.CONFIG.save();
                    PluginConfig.INSTANCE.reload();
                    this.rebuildWidgets();
                }
                catch (Throwable e) {
                    Jade.LOGGER.error("", e);
                }
            }
            this.minecraft.setScreen((Screen)this);
            this.options.setScrollAmount(this.options.getMaxScroll());
        }, title, (Component)Component.translatable((String)OptionsList.Entry.makeKey("reset_settings.confirm")), reset, (Component)Component.translatable((String)"gui.cancel")));
    }
}

