/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.gui.config.KeybindOptionButton;
import snownee.jade.gui.config.value.CycleOptionValue;
import snownee.jade.gui.config.value.InputOptionValue;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.gui.config.value.SliderOptionValue;
import snownee.jade.util.ClientProxy;

public class OptionsList
extends ContainerObjectSelectionList<Entry> {
    public static final Component OPTION_ON = CommonComponents.OPTION_ON.copy().withStyle(style -> style.withColor(-4589878));
    public static final Component OPTION_OFF = CommonComponents.OPTION_OFF.copy().withStyle(style -> style.withColor(-30080));
    public final Set<Entry> forcePreview = Sets.newIdentityHashSet();
    protected final List<Entry> entries = Lists.newArrayList();
    private final Runnable diskWriter;
    public Title currentTitle;
    public KeyMapping selectedKey;
    private BaseOptionsScreen owner;
    private double targetScroll;
    private Entry defaultParent;
    private int lastActiveIndex;

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int entryHeight, Runnable diskWriter) {
        super(client, width, height, y0, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
    }

    public OptionsList(BaseOptionsScreen owner, Minecraft client, int width, int height, int y0, int entryHeight) {
        this(owner, client, width, height, y0, entryHeight, null);
    }

    private static void walkChildren(Entry entry, Consumer<Entry> consumer) {
        consumer.accept(entry);
        for (Entry child : entry.children) {
            OptionsList.walkChildren(child, consumer);
        }
    }

    public int getRowWidth() {
        return Math.min(this.width, 300);
    }

    protected int getScrollbarPosition() {
        return this.owner.width - 6;
    }

    public void setScrollAmount(double d) {
        super.setScrollAmount(d);
        this.targetScroll = this.getScrollAmount();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double speed = !ClientProxy.hasFastScroll && Screen.hasControlDown() ? 4.5 : 1.5;
        this.targetScroll = this.getScrollAmount() - deltaY * (double)this.itemHeight * speed;
        return true;
    }

    public boolean isFocused() {
        return this.owner.getFocused() == this;
    }

    protected boolean isSelectedItem(int i) {
        if (PreviewOptionsScreen.isAdjustingPosition()) {
            return false;
        }
        return Objects.equals(this.getSelected(), this.children().get(i));
    }

    protected void renderItem(GuiGraphics guiGraphics, int i, int j, float f, int k, int l, int m, int n, int o) {
        if (this.isSelectedItem(k) && this.isMouseOver(i, j)) {
            this.renderSelection(guiGraphics, m, n, o, -1, -1);
        }
        super.renderItem(guiGraphics, i, j, f, k, l, m, n, o);
    }

    protected void renderSelection(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        guiGraphics.fill(this.getX(), i - 2, this.getRight(), i + k + 2, 0x33FFFFFF);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.targetScroll = Math.min(this.targetScroll, (double)this.getMaxScroll());
        double diff = this.targetScroll - super.getScrollAmount();
        if (Math.abs(diff) > 3.0E-4) {
            super.setScrollAmount(super.getScrollAmount() + diff * (double)delta);
        }
        this.hovered = null;
        if (!PreviewOptionsScreen.isAdjustingPosition()) {
            int activeIndex;
            if (this.isMouseOver(mouseX, mouseY)) {
                this.hovered = this.getEntryAtPosition(mouseX, mouseY);
            }
            if (this.hovered instanceof Title) {
                this.setSelected(null);
            } else {
                this.setSelected((AbstractSelectionList.Entry)((Entry)this.hovered));
            }
            int n = activeIndex = this.hovered != null ? this.children().indexOf(this.hovered) : Mth.clamp((int)((int)this.getScrollAmount() / this.itemHeight), (int)0, (int)(this.getItemCount() - 1));
            if (activeIndex >= 0 && activeIndex != this.lastActiveIndex) {
                this.lastActiveIndex = activeIndex;
                Entry entry = (Entry)this.getEntry(activeIndex);
                while (entry != null) {
                    if (entry instanceof Title) {
                        this.currentTitle = (Title)entry;
                        break;
                    }
                    entry = entry.parent;
                }
            }
        }
        this.enableScissor(guiGraphics);
        this.renderList(guiGraphics, mouseX, mouseY, delta);
        int k = this.getMaxScroll();
        k = this.getMaxScroll();
        if (k > 0) {
            int l = this.getScrollbarPosition();
            int m = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
            m = Mth.clamp((int)m, (int)32, (int)(this.height - 8));
            int n = (int)this.getScrollAmount() * (this.height - m) / k + this.getY();
            if (n < this.getY()) {
                n = this.getY();
            }
            guiGraphics.fill(l, this.getY(), l + 6, this.getBottom(), -16777216);
            guiGraphics.blitSprite(SCROLLER_SPRITE, l, n, 6, m);
        }
        this.renderDecorations(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        guiGraphics.disableScissor();
        guiGraphics.setColor(0.35f, 0.35f, 0.35f, 1.0f);
        guiGraphics.blit(Screen.BACKGROUND_LOCATION, 0, this.owner.height - 32, (float)this.owner.width, 32.0f, this.owner.width, this.owner.height, 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.fillGradient(0, this.owner.height - 32 - 4, this.owner.width, this.owner.height - 32, 40, 0, -301989888);
    }

    public void save() {
        this.children().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public <T extends Entry> T add(T entry) {
        this.entries.add(entry);
        if (entry instanceof Title) {
            this.setDefaultParent(entry);
        } else if (this.defaultParent != null) {
            entry.parent(this.defaultParent);
        }
        return entry;
    }

    @Nullable
    public Entry getEntryAt(double x, double y) {
        return (Entry)this.getEntryAtPosition(x, y);
    }

    public int getRowTop(int i) {
        return super.getRowTop(i);
    }

    public int getRowBottom(int i) {
        return super.getRowBottom(i);
    }

    public void setDefaultParent(Entry defaultParent) {
        this.defaultParent = defaultParent;
    }

    public MutableComponent title(String string) {
        return this.add(new Title(string)).getTitle();
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter) {
        return this.slider(optionName, value, setter, 0.0f, 1.0f, FloatUnaryOperator.identity());
    }

    public OptionValue<Float> slider(String optionName, float value, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        return this.add(new SliderOptionValue(optionName, value, setter, min, max, aligner));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        return this.add(new InputOptionValue<T>(this::updateSaveState, optionName, value, setter, validator));
    }

    public <T> OptionValue<T> input(String optionName, T value, Consumer<T> setter) {
        return this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter) {
        return this.choices(optionName, value, setter, null);
    }

    public OptionValue<Boolean> choices(String optionName, boolean value, BooleanConsumer setter, @Nullable Consumer<CycleButton.Builder<Boolean>> builderConsumer) {
        CycleButton.Builder builder = CycleButton.booleanBuilder((Component)OPTION_ON, (Component)OPTION_OFF);
        if (builderConsumer != null) {
            builderConsumer.accept((CycleButton.Builder<Boolean>)builder);
        }
        return this.add(new CycleOptionValue<Boolean>(optionName, (CycleButton.Builder<Boolean>)builder, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter) {
        return this.choices(optionName, value, setter, null);
    }

    public <T extends Enum<T>> OptionValue<T> choices(String optionName, T value, Consumer<T> setter, @Nullable Consumer<CycleButton.Builder<T>> builderConsumer) {
        List<Enum> values = Arrays.asList((Enum[])value.getClass().getEnumConstants());
        CycleButton.Builder builder = CycleButton.builder(v -> {
            String name;
            return switch (name = v.name().toLowerCase(Locale.ENGLISH)) {
                case "on" -> OPTION_ON;
                case "off" -> OPTION_OFF;
                default -> Entry.makeTitle(optionName + "_" + name);
            };
        }).withValues(values);
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return this.add(new CycleOptionValue<T>(optionName, builder, value, setter));
    }

    public <T> OptionValue<T> choices(String optionName, T value, List<T> values, Consumer<T> setter, Function<T, Component> nameProvider) {
        return this.add(new CycleOptionValue<T>(optionName, CycleButton.builder(nameProvider).withValues(values), value, setter));
    }

    public void keybind(KeyMapping keybind) {
        this.add(new KeybindOptionButton(this, keybind));
    }

    public void removed() {
        this.forcePreview.clear();
        for (Entry entry : this.entries) {
            entry.parent = null;
            if (entry.children.isEmpty()) continue;
            entry.children.clear();
        }
        this.clearEntries();
        this.owner = null;
    }

    public void updateSearch(String search) {
        this.clearEntries();
        if (search.isBlank()) {
            this.entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
            return;
        }
        LinkedHashSet matches = Sets.newLinkedHashSet();
        String[] keywords = search.split("\\s+");
        for (Entry entry : this.entries) {
            int bingo = 0;
            block1: for (String keyword : keywords) {
                keyword = keyword.toLowerCase(Locale.ENGLISH);
                for (String message : entry.getMessages()) {
                    if (!message.contains(keyword)) continue;
                    ++bingo;
                    continue block1;
                }
            }
            if (bingo != keywords.length) continue;
            OptionsList.walkChildren(entry, matches::add);
            while (entry.parent != null) {
                entry = entry.parent;
                matches.add(entry);
            }
        }
        for (Entry entry : this.entries) {
            if (!matches.contains((Object)entry)) continue;
            this.addEntry((AbstractSelectionList.Entry)entry);
        }
        if (matches.isEmpty()) {
            this.addEntry((AbstractSelectionList.Entry)new Title(Component.translatable((String)"gui.jade.no_results").withStyle(ChatFormatting.GRAY)));
        }
    }

    public void updateSaveState() {
        for (Entry entry : this.entries) {
            OptionValue value;
            if (!(entry instanceof OptionValue) || (value = (OptionValue)entry).isValidValue()) continue;
            this.owner.saveButton.active = false;
            return;
        }
        this.owner.saveButton.active = true;
    }

    public void showOnTop(Entry entry) {
        this.targetScroll = this.itemHeight * this.children().indexOf((Object)entry) + 1;
    }

    public void resetMappingAndUpdateButtons() {
        for (Entry entry : this.entries) {
            if (!(entry instanceof KeybindOptionButton)) continue;
            KeybindOptionButton button = (KeybindOptionButton)entry;
            button.refresh(this.selectedKey);
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.selectedKey != null) {
            Options options = Minecraft.getInstance().options;
            if (i == 256) {
                options.setKey(this.selectedKey, InputConstants.UNKNOWN);
            } else {
                options.setKey(this.selectedKey, InputConstants.getKey((int)i, (int)j));
            }
            this.selectedKey = null;
            this.resetMappingAndUpdateButtons();
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client;
        private final List<String> messages = Lists.newArrayList();
        private final List<AbstractWidget> widgets = Lists.newArrayList();
        private final List<Vector2i> widgetOffsets = Lists.newArrayList();
        @Nullable
        protected String description;
        private Entry parent;
        private List<Entry> children = List.of();

        public Entry() {
            this.client = Minecraft.getInstance();
        }

        public static MutableComponent makeTitle(String key) {
            return Component.translatable((String)Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return Util.makeDescriptionId((String)"config", (ResourceLocation)new ResourceLocation("jade", key));
        }

        public AbstractWidget getFirstWidget() {
            return this.widgets.isEmpty() ? null : this.widgets.get(0);
        }

        public void addWidget(AbstractWidget widget, int offsetX) {
            this.addWidget(widget, offsetX, -widget.getHeight() / 2);
        }

        public void addWidget(AbstractWidget widget, int offsetX, int offsetY) {
            this.widgets.add(widget);
            this.widgetOffsets.add(new Vector2i(offsetX, offsetY));
        }

        public List<? extends AbstractWidget> children() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children();
        }

        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            for (AbstractWidget widget : this.widgets) {
                Vector2i offset = this.widgetOffsets.get(this.widgets.indexOf(widget));
                widget.setX(rowLeft + width - 110 + offset.x);
                widget.setY(rowTop + height / 2 + offset.y);
                widget.render(guiGraphics, mouseX, mouseY, deltaTime);
            }
        }

        public void setDisabled(boolean b) {
            for (AbstractWidget widget : this.widgets) {
                boolean bl = widget.active = !b;
                if (!(widget instanceof EditBox)) continue;
                EditBox box = (EditBox)widget;
                box.setEditable(!b);
            }
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public int getTextX(int width) {
            return 0;
        }

        public int getTextWidth() {
            return 0;
        }

        public Entry parent(Entry parent) {
            this.parent = parent;
            if (parent.children.isEmpty()) {
                parent.children = Lists.newArrayList();
            }
            parent.children.add(this);
            return this;
        }

        public Entry parent() {
            return this.parent;
        }

        public final List<String> getMessages() {
            return this.messages;
        }

        public void addMessage(String message) {
            this.messages.add(StringUtil.stripColor((String)message).toLowerCase(Locale.ENGLISH));
        }

        public void addMessageKey(String key) {
            if (I18n.exists((String)(key = Entry.makeKey(key + "_extra_msg")))) {
                this.addMessage(I18n.get((String)key, (Object[])new Object[0]));
            }
        }
    }

    public static class Title
    extends Entry {
        public Component narration;
        private final MutableComponent title;
        private int x;

        public Title(String key) {
            this.title = Title.makeTitle(key);
            this.addMessageKey(key);
            this.addMessage(this.title.getString());
            key = Title.makeKey(key + "_desc");
            if (I18n.exists((String)key)) {
                this.description = I18n.get((String)key, (Object[])new Object[0]);
                this.addMessage(this.description);
            }
            this.narration = Component.translatable((String)"narration.jade.category", (Object[])new Object[]{this.title});
        }

        public Title(MutableComponent title) {
            this.title = title;
            this.narration = title;
        }

        public MutableComponent getTitle() {
            return this.title;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            this.x = rowLeft;
            Font font = this.client.font;
            int n = this.getTextX(width);
            Objects.requireNonNull(this.client.font);
            guiGraphics.drawString(font, (Component)this.title, n, rowTop + height - 9, 0xFFFFFF);
        }

        @Override
        public int getTextX(int width) {
            return this.x + (width - this.client.font.width((FormattedText)this.title)) / 2;
        }

        @Override
        public int getTextWidth() {
            return this.client.font.width((FormattedText)this.title);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.add(NarratedElementType.TITLE, narration);
                }
            });
        }
    }
}

