/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.util.SmoothChasingValue;

public class OptionsNav
extends ObjectSelectionList<Entry> {
    private final OptionsList options;
    private final SmoothChasingValue anchor;

    public OptionsNav(OptionsList options, int width, int height, int top, int itemHeight) {
        super(Minecraft.getInstance(), width, height, top, itemHeight);
        this.options = options;
        this.anchor = new SmoothChasingValue();
        this.setRenderBackground(false);
    }

    protected void renderList(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderList(guiGraphics, i, j, f);
        this.anchor.tick(f);
        if (this.children().isEmpty()) {
            return;
        }
        int top = (int)((double)(this.getY() + 4) - this.getScrollAmount() + (double)(this.anchor.value * (float)this.itemHeight) + (double)this.headerHeight);
        int left = this.getRowLeft() + 2;
        guiGraphics.fill(left, top, left + 2, top + this.itemHeight - 4, -1);
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.setColor(0.125f, 0.125f, 0.125f, 1.0f);
        guiGraphics.blit(Screen.BACKGROUND_LOCATION, this.getX(), this.getY(), (float)this.getRight(), (float)(this.getBottom() + (int)this.getScrollAmount()), this.getWidth(), this.getHeight(), 32, 32);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        super.renderWidget(guiGraphics, i, j, f);
    }

    protected void renderSelection(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
    }

    public void addEntry(OptionsList.Title entry) {
        super.addEntry((AbstractSelectionList.Entry)new Entry(this, entry));
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getRowLeft() + this.getRowWidth() - 8;
    }

    public void refresh() {
        this.clearEntries();
        if (this.options.children().size() <= 1) {
            return;
        }
        for (OptionsList.Entry child : this.options.children()) {
            if (!(child instanceof OptionsList.Title)) continue;
            OptionsList.Title titleEntry = (OptionsList.Title)child;
            this.addEntry(titleEntry);
        }
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final OptionsList.Title title;
        private final OptionsNav parent;

        public Entry(OptionsNav parent, OptionsList.Title title) {
            this.parent = parent;
            this.title = title;
        }

        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            Font font = this.title.client.font;
            String string = this.title.getTitle().getString();
            int n = rowTop + height / 2;
            Objects.requireNonNull(this.title.client.font);
            guiGraphics.drawString(font, string, rowLeft + 10, n - 9 / 2, 0xFFFFFF);
            if (this.parent.options.currentTitle == this.title) {
                if (!this.parent.isMouseOver(mouseX, mouseY)) {
                    this.parent.ensureVisible((AbstractSelectionList.Entry)this);
                }
                this.parent.anchor.target(index);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.parent.options.showOnTop(this.title);
            }
            return true;
        }

        public Component getNarration() {
            return this.title.narration;
        }
    }
}

