/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import snownee.jade.gui.config.value.OptionValue;

public class InputOptionValue<T>
extends OptionValue<T> {
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?[0-9]+");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)");
    private final EditBox textField;
    private final Predicate<String> validator;

    public InputOptionValue(Runnable responder, String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        super(optionName, setter);
        this.value = value;
        this.validator = validator;
        this.textField = new EditBox(this.client.font, 0, 0, 98, 18, (Component)Component.literal((String)""));
        this.textField.setValue(String.valueOf(value));
        this.textField.setResponder(s -> {
            if (this.validator.test((String)s)) {
                this.setValue((String)s);
                this.textField.setTextColor(ChatFormatting.WHITE.getColor().intValue());
            } else {
                this.textField.setTextColor(ChatFormatting.RED.getColor().intValue());
            }
            responder.run();
        });
        this.addWidget((AbstractWidget)this.textField, 0);
    }

    @Override
    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            if (this.value instanceof Integer) {
                this.value = Integer.valueOf(text);
            } else if (this.value instanceof Short) {
                this.value = Short.valueOf(text);
            } else if (this.value instanceof Byte) {
                this.value = Byte.valueOf(text);
            } else if (this.value instanceof Long) {
                this.value = Long.valueOf(text);
            } else if (this.value instanceof Double) {
                this.value = Double.valueOf(text);
            } else if (this.value instanceof Float) {
                this.value = Float.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.save();
    }

    @Override
    public boolean isValidValue() {
        return this.validator.test(this.textField.getValue());
    }

    @Override
    public void setValue(T value) {
        this.textField.setValue(String.valueOf(value));
    }
}

