/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<BlockHitResult>
implements BlockAccessor {
    private final BlockState blockState;
    @Nullable
    private final java.util.function.Supplier<BlockEntity> blockEntity;
    private ItemStack fakeBlock;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, Suppliers.ofInstance((Object)builder.hit), builder.connected, builder.showDetails);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.fakeBlock = builder.fakeBlock;
    }

    public static void handleRequest(SyncData data, ServerPlayer player, Consumer<Runnable> executor, Consumer<CompoundTag> responseSender) {
        executor.accept(() -> {
            BlockAccessor accessor = data.unpack(player);
            if (accessor == null) {
                return;
            }
            BlockPos pos = accessor.getPosition();
            ServerLevel world = player.serverLevel();
            if (pos.distSqr((Vec3i)player.blockPosition()) > (double)Jade.MAX_DISTANCE_SQR || !world.isLoaded(pos)) {
                return;
            }
            BlockEntity tile = accessor.getBlockEntity();
            if (tile == null) {
                return;
            }
            List<IServerDataProvider<BlockAccessor>> providers = WailaCommonRegistration.instance().getBlockNBTProviders(tile);
            if (providers.isEmpty()) {
                return;
            }
            CompoundTag tag = accessor.getServerData();
            for (IServerDataProvider<BlockAccessor> provider : providers) {
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.putInt("x", pos.getX());
            tag.putInt("y", pos.getY());
            tag.putInt("z", pos.getZ());
            tag.putString("id", CommonProxy.getId(tile.getType()).toString());
            responseSender.accept(tag);
        });
    }

    @Override
    @Deprecated
    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.showDetails());
        buf.writeBlockHitResult((BlockHitResult)this.getHitResult());
        buf.writeVarInt(Block.getId((BlockState)this.blockState));
        buf.writeItem(this.fakeBlock);
    }

    @Override
    public Block getBlock() {
        return this.getBlockState().getBlock();
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this.blockEntity == null ? null : this.blockEntity.get();
    }

    @Override
    public BlockPos getPosition() {
        return ((BlockHitResult)this.getHitResult()).getBlockPos();
    }

    @Override
    public Direction getSide() {
        return ((BlockHitResult)this.getHitResult()).getDirection();
    }

    @Override
    public ItemStack getPickedResult() {
        return CommonProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (BlockHitResult)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getBlockEntity();
    }

    @Override
    public boolean isFakeBlock() {
        return !this.fakeBlock.isEmpty();
    }

    @Override
    public ItemStack getFakeBlock() {
        return this.fakeBlock;
    }

    public void setFakeBlock(ItemStack fakeBlock) {
        this.fakeBlock = fakeBlock;
    }

    @Override
    public boolean verifyData(CompoundTag data) {
        if (!this.verify) {
            return true;
        }
        int x = data.getInt("x");
        int y = data.getInt("y");
        int z = data.getInt("z");
        BlockPos hitPos = this.getPosition();
        return x == hitPos.getX() && y == hitPos.getY() && z == hitPos.getZ();
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private boolean showDetails;
        private BlockHitResult hit;
        private BlockState blockState = Blocks.AIR.defaultBlockState();
        private java.util.function.Supplier<BlockEntity> blockEntity;
        private ItemStack fakeBlock = ItemStack.EMPTY;
        private boolean verify;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(BlockHitResult hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(BlockState blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(java.util.function.Supplier<BlockEntity> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder fakeBlock(ItemStack stack) {
            this.fakeBlock = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (BlockHitResult)accessor.getHitResult();
            this.blockEntity = accessor::getBlockEntity;
            this.blockState = accessor.getBlockState();
            this.fakeBlock = accessor.getFakeBlock();
            return this;
        }

        @Override
        public BlockAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public BlockAccessor build() {
            BlockAccessorImpl accessor = new BlockAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, BlockHitResult hit, BlockState blockState, ItemStack fakeBlock) {
        public SyncData(BlockAccessor accessor) {
            this(accessor.showDetails(), (BlockHitResult)accessor.getHitResult(), accessor.getBlockState(), accessor.getFakeBlock());
        }

        public SyncData(FriendlyByteBuf buffer) {
            this(buffer.readBoolean(), buffer.readBlockHitResult(), Block.stateById((int)buffer.readVarInt()), buffer.readItem());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.showDetails);
            buffer.writeBlockHitResult(this.hit);
            buffer.writeVarInt(Block.getId((BlockState)this.blockState));
            buffer.writeItem(this.fakeBlock);
        }

        public BlockAccessor unpack(ServerPlayer player) {
            Supplier blockEntity = null;
            if (this.blockState.hasBlockEntity()) {
                blockEntity = Suppliers.memoize(() -> player.level().getBlockEntity(this.hit.getBlockPos()));
            }
            return ((Builder)new Builder().level(player.level()).player((Player)player).showDetails(this.showDetails).hit(this.hit).blockState(this.blockState).blockEntity((java.util.function.Supplier)blockEntity)).fakeBlock(this.fakeBlock).build();
        }
    }
}

