/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<EntityHitResult>
implements EntityAccessor {
    private final java.util.function.Supplier<Entity> entity;

    public EntityAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected, builder.showDetails);
        this.entity = builder.entity;
    }

    public static void handleRequest(SyncData data, ServerPlayer player, Consumer<Runnable> executor, Consumer<CompoundTag> responseSender) {
        executor.accept(() -> {
            EntityAccessor accessor = data.unpack(player);
            if (accessor == null) {
                return;
            }
            Entity entity = accessor.getEntity();
            if (entity == null || player.distanceToSqr(entity) > (double)Jade.MAX_DISTANCE_SQR) {
                return;
            }
            List<IServerDataProvider<EntityAccessor>> providers = WailaCommonRegistration.instance().getEntityNBTProviders(entity);
            if (providers.isEmpty()) {
                return;
            }
            CompoundTag tag = accessor.getServerData();
            for (IServerDataProvider<EntityAccessor> provider : providers) {
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.putInt("WailaEntityID", entity.getId());
            responseSender.accept(tag);
        });
    }

    @Override
    @Deprecated
    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.showDetails());
        Entity entity = this.getEntity();
        buf.writeVarInt(entity.getId());
        if (CommonProxy.isMultipartEntity(entity)) {
            buf.writeVarInt(CommonProxy.getPartEntityIndex(entity));
        } else {
            buf.writeVarInt(-1);
        }
        Vec3 hitVec = ((EntityHitResult)this.getHitResult()).getLocation();
        buf.writeFloat((float)hitVec.x);
        buf.writeFloat((float)hitVec.y);
        buf.writeFloat((float)hitVec.z);
    }

    @Override
    public Entity getEntity() {
        return CommonProxy.wrapPartEntityParent(this.getRawEntity());
    }

    @Override
    public Entity getRawEntity() {
        return this.entity.get();
    }

    @Override
    public ItemStack getPickedResult() {
        return CommonProxy.getEntityPickedResult(this.entity.get(), this.getPlayer(), (EntityHitResult)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getEntity();
    }

    @Override
    public boolean verifyData(CompoundTag data) {
        if (!this.verify) {
            return true;
        }
        if (!data.contains("WailaEntityID")) {
            return false;
        }
        return data.getInt("WailaEntityID") == this.getEntity().getId();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        public boolean showDetails;
        private Level level;
        private Player player;
        private CompoundTag serverData;
        private boolean connected;
        private java.util.function.Supplier<EntityHitResult> hit;
        private java.util.function.Supplier<Entity> entity;
        private boolean verify;

        @Override
        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(CompoundTag serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(java.util.function.Supplier<EntityHitResult> hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(java.util.function.Supplier<Entity> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = accessor::getHitResult;
            this.entity = accessor::getEntity;
            return this;
        }

        @Override
        public EntityAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public EntityAccessor build() {
            EntityAccessorImpl accessor = new EntityAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, int id, int partIndex, Vec3 hitVec) {
        public SyncData(EntityAccessor accessor) {
            this(accessor.showDetails(), accessor.getEntity().getId(), CommonProxy.getPartEntityIndex(accessor.getRawEntity()), ((EntityHitResult)accessor.getHitResult()).getLocation());
        }

        public SyncData(FriendlyByteBuf buffer) {
            this(buffer.readBoolean(), buffer.readVarInt(), buffer.readVarInt(), new Vec3((double)buffer.readFloat(), (double)buffer.readFloat(), (double)buffer.readFloat()));
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.showDetails);
            buffer.writeVarInt(this.id);
            buffer.writeVarInt(this.partIndex);
            buffer.writeFloat((float)this.hitVec.x);
            buffer.writeFloat((float)this.hitVec.y);
            buffer.writeFloat((float)this.hitVec.z);
        }

        public EntityAccessor unpack(ServerPlayer player) {
            Supplier entity = Suppliers.memoize(() -> CommonProxy.getPartEntity(player.level().getEntity(this.id), this.partIndex));
            return ((Builder)((Builder)new Builder().level(player.level()).player((Player)player).showDetails(this.showDetails).entity((java.util.function.Supplier)entity)).hit((java.util.function.Supplier)Suppliers.memoize(() -> this.lambda$unpack$1((java.util.function.Supplier)entity)))).build();
        }

        private /* synthetic */ EntityHitResult lambda$unpack$1(java.util.function.Supplier entity) {
            return new EntityHitResult((Entity)entity.get(), this.hitVec);
        }
    }
}

