/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Identifiers;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;

public class ArmorElement
extends Element {
    public static final ResourceLocation ARMOR = new ResourceLocation("hud/armor_full");
    public static final ResourceLocation HALF_ARMOR = new ResourceLocation("hud/armor_half");
    public static final ResourceLocation EMPTY_ARMOR = new ResourceLocation("hud/armor_empty");
    private final float armor;

    public ArmorElement(float armor) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
            armor = Mth.ceil((float)armor);
        }
        this.armor = armor;
    }

    @Override
    public Vec2 getSize() {
        if (this.armor > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            Font font = Minecraft.getInstance().font;
            return new Vec2((float)(9 + font.width(text)), 10.0f);
        }
        int maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        int lineCount = (int)Math.ceil(this.armor / (float)maxHearts * 0.5f);
        return new Vec2((float)(9 * maxHearts), (float)(10 * lineCount));
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        IDisplayHelper helper = IDisplayHelper.get();
        if (this.armor > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            helper.blitSprite(guiGraphics, ARMOR, (int)x, (int)y, 9, 9);
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            helper.drawText(guiGraphics, text, x + 9.0f, y, IThemeHelper.get().getNormalColor());
        } else {
            float armor = this.armor * 0.5f;
            int maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            int lineCount = (int)Math.ceil(armor / (float)maxHearts);
            int armorCount = lineCount * maxHearts;
            int xOffset = 0;
            for (int i = 1; i <= armorCount; ++i) {
                if (i <= Mth.floor((float)armor)) {
                    helper.blitSprite(guiGraphics, ARMOR, (int)x + xOffset, (int)y, 9, 9);
                }
                if ((float)i > armor && (float)i < armor + 1.0f) {
                    helper.blitSprite(guiGraphics, HALF_ARMOR, (int)x + xOffset, (int)y, 9, 9);
                }
                if ((float)i >= armor + 1.0f) {
                    helper.blitSprite(guiGraphics, EMPTY_ARMOR, (int)x + xOffset, (int)y, 9, 9);
                }
                xOffset += 9;
                if (i % maxHearts != 0) continue;
                y += 10.0f;
                xOffset = 0;
            }
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return I18n.get((String)"narration.jade.armor", (Object[])new Object[]{DisplayHelper.dfCommas.format(this.armor)});
    }
}

