/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.impl.BlockAccessorImpl;

public class DatapackBlockManager {
    private static final Set<BlockPos> itemFrames = Sets.newConcurrentHashSet();

    public static void onEntityJoin(Entity entity) {
        if (entity.getType() == EntityType.ITEM_FRAME || entity.getType() == EntityType.GLOW_ITEM_FRAME) {
            itemFrames.add(entity.blockPosition());
        }
    }

    public static void onEntityLeave(Entity entity) {
        if (entity.getType() == EntityType.ITEM_FRAME || entity.getType() == EntityType.GLOW_ITEM_FRAME) {
            BlockPos pos = entity.blockPosition();
            DatapackBlockManager.getFakeBlock((LevelAccessor)entity.level(), pos);
        }
    }

    public static ItemStack getFakeBlock(LevelAccessor level, BlockPos pos) {
        if (itemFrames.contains(pos)) {
            List entities = level.getEntitiesOfClass(ItemFrame.class, new AABB(pos), $ -> $.isInvisible() && $.isAlive());
            if (entities.isEmpty()) {
                itemFrames.remove(pos);
            } else {
                ItemStack stack = ((ItemFrame)entities.get(0)).getItem();
                if (stack.hasTag() && stack.getTag().contains("storedItem")) {
                    stack = ItemStack.of((CompoundTag)stack.getTagElement("storedItem"));
                }
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static Accessor<?> override(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        BlockAccessorImpl target;
        if (accessor instanceof BlockAccessorImpl && (target = (BlockAccessorImpl)accessor).getFakeBlock().isEmpty()) {
            target.setFakeBlock(DatapackBlockManager.getFakeBlock((LevelAccessor)target.getLevel(), target.getPosition()));
        }
        return accessor;
    }
}

