/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerPingPacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeForgeUtils;
import snownee.jade.util.WailaExceptionHandler;

@Mod(value="jade")
public final class CommonProxy {
    public CommonProxy(IEventBus modBus) {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        modBus.addListener(this::loadComplete);
        modBus.addListener(this::registerPayloadHandlers);
        NeoForge.EVENT_BUS.addListener(CommonProxy::playerJoin);
        NeoForge.EVENT_BUS.addListener(CommonProxy::registerServerCommand);
        if (CommonProxy.isPhysicallyClient()) {
            ClientProxy.init(modBus);
        }
    }

    private void registerPayloadHandlers(RegisterPayloadHandlerEvent event) {
        event.registrar("jade").versioned("2").optional().play(Identifiers.PACKET_RECEIVE_DATA, ReceiveDataPacket::read, handlers -> handlers.client(ReceiveDataPacket::handle)).play(Identifiers.PACKET_SERVER_PING, ServerPingPacket::read, handlers -> handlers.client(ServerPingPacket::handle)).play(Identifiers.PACKET_REQUEST_ENTITY, RequestEntityPacket::read, handlers -> handlers.server(RequestEntityPacket::handle)).play(Identifiers.PACKET_REQUEST_TILE, RequestBlockPacket::read, handlers -> handlers.server(RequestBlockPacket::handle)).play(Identifiers.PACKET_SHOW_OVERLAY, ShowOverlayPacket::read, handlers -> handlers.client(ShowOverlayPacket::handle));
    }

    public static int showOrHideFromServer(Collection<ServerPlayer> players, boolean show) {
        ShowOverlayPacket msg = new ShowOverlayPacket(show);
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)msg);
        }
        return players.size();
    }

    private static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        String configs = PluginConfig.INSTANCE.getServerConfigs();
        if (!configs.isEmpty()) {
            Jade.LOGGER.debug("Syncing config to {} ({})", (Object)event.getEntity().getGameProfile().getName(), (Object)event.getEntity().getGameProfile().getId());
        }
        player.connection.send((CustomPacketPayload)new ServerPingPacket(configs));
    }

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static boolean isShears(ItemStack tool) {
        return tool.is(Tags.Items.SHEARS);
    }

    public static boolean isShearable(BlockState state) {
        return state.getBlock() instanceof IShearable;
    }

    public static boolean isCorrectToolForDrops(BlockState state, Player player) {
        return CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }

    public static String getModIdFromItem(ItemStack stack) {
        ResourceLocation id;
        String s;
        if (stack.hasTag() && stack.getTag().contains("id") && (s = stack.getTag().getString("id")).contains(":") && (id = ResourceLocation.tryParse((String)s)) != null) {
            return id.getNamespace();
        }
        return stack.getItem().getCreatorModId(stack);
    }

    public static boolean isPhysicallyClient() {
        return FMLEnvironment.dist.isClient();
    }

    private static void registerServerCommand(RegisterCommandsEvent event) {
        JadeServerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ItemCollector<?> createItemCollector(Accessor<?> accessor, Cache<Object, ItemCollector<?>> containerCache) {
        Object target = accessor.getTarget();
        if (!(target instanceof Entity) || target instanceof AbstractChestedHorse) {
            try {
                IItemHandler itemHandler = CommonProxy.findItemHandler(accessor);
                if (itemHandler != null) {
                    return (ItemCollector)containerCache.get((Object)itemHandler, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler(itemHandler, target instanceof AbstractChestedHorse ? 2 : 0)));
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        if (target instanceof Container) {
            if (target instanceof ChestBlockEntity) {
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(a -> {
                    Object o = a.getTarget();
                    if (o instanceof ChestBlockEntity) {
                        ChestBlock chestBlock;
                        Container compound;
                        ChestBlockEntity be = (ChestBlockEntity)o;
                        Block patt7802$temp = be.getBlockState().getBlock();
                        if (patt7802$temp instanceof ChestBlock && (compound = ChestBlock.getContainer((ChestBlock)(chestBlock = (ChestBlock)patt7802$temp), (BlockState)be.getBlockState(), (Level)a.getLevel(), (BlockPos)be.getBlockPos(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> containerGroup(Container container, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.INSTANCE.containerCache.get((Object)container, () -> new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0)))).update(accessor, accessor.getLevel().getGameTime());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> storageGroup(Object storage, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.INSTANCE.containerCache.get(storage, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler((IItemHandler)storage, 0)))).update(accessor, accessor.getLevel().getGameTime());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public static IItemHandler findItemHandler(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor ba = (BlockAccessor)accessor;
            return (IItemHandler)ba.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, ba.getPosition(), ba.getBlockState(), ba.getBlockEntity(), null);
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor ea = (EntityAccessor)accessor;
            return (IItemHandler)ea.getEntity().getCapability(Capabilities.ItemHandler.ENTITY, null);
        }
        return null;
    }

    public static List<ViewGroup<CompoundTag>> wrapFluidStorage(Accessor<?> accessor, Object target) {
        EntityAccessor ea;
        IFluidHandler fluidHandler;
        if (accessor instanceof BlockAccessor) {
            BlockAccessor ba = (BlockAccessor)accessor;
            IFluidHandler fluidHandler2 = (IFluidHandler)ba.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, ba.getPosition(), ba.getBlockState(), ba.getBlockEntity(), null);
            if (fluidHandler2 != null) {
                return JadeForgeUtils.fromFluidHandler(fluidHandler2);
            }
        } else if (accessor instanceof EntityAccessor && (fluidHandler = (IFluidHandler)(ea = (EntityAccessor)accessor).getEntity().getCapability(Capabilities.FluidHandler.ENTITY, null)) != null) {
            return JadeForgeUtils.fromFluidHandler(fluidHandler);
        }
        return null;
    }

    public static List<ViewGroup<CompoundTag>> wrapEnergyStorage(Accessor<?> accessor, Object target) {
        EntityAccessor ea;
        IEnergyStorage energyStorage;
        if (accessor instanceof BlockAccessor) {
            BlockAccessor ba = (BlockAccessor)accessor;
            IEnergyStorage energyStorage2 = (IEnergyStorage)ba.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, ba.getPosition(), ba.getBlockState(), ba.getBlockEntity(), null);
            if (energyStorage2 != null) {
                ViewGroup<CompoundTag> group = new ViewGroup<CompoundTag>(List.of(EnergyView.of(energyStorage2.getEnergyStored(), energyStorage2.getMaxEnergyStored())));
                group.getExtraData().putString("Unit", "FE");
                return List.of(group);
            }
        } else if (accessor instanceof EntityAccessor && (energyStorage = (IEnergyStorage)(ea = (EntityAccessor)accessor).getEntity().getCapability(Capabilities.EnergyStorage.ENTITY, null)) != null) {
            ViewGroup<CompoundTag> group = new ViewGroup<CompoundTag>(List.of(EnergyView.of(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored())));
            group.getExtraData().putString("Unit", "FE");
            return List.of(group);
        }
        return null;
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }

    public static float getEnchantPowerBonus(BlockState state, Level world, BlockPos pos) {
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static ResourceLocation getId(BlockEntityType<?> blockEntityType) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType);
    }

    public static ResourceLocation getId(PaintingVariant motive) {
        return BuiltInRegistries.PAINTING_VARIANT.getKey((Object)motive);
    }

    public static String getPlatformIdentifier() {
        return "neoforge";
    }

    public static MutableComponent getProfressionName(VillagerProfession profession) {
        ResourceLocation profName = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
        return Component.translatable((String)(EntityType.VILLAGER.getDescriptionId() + "." + (String)(!"minecraft".equals(profName.getNamespace()) ? profName.getNamespace() + "." : "") + profName.getPath()));
    }

    public static boolean isBoss(Entity entity) {
        EntityType entityType = entity.getType();
        return entityType.is(Tags.EntityTypes.BOSSES) || entityType == EntityType.ENDER_DRAGON || entityType == EntityType.WITHER;
    }

    public static boolean isModLoaded(String modid) {
        try {
            return ModList.get().isLoaded(modid);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ItemStack getBlockPickedResult(BlockState state, Player player, BlockHitResult hitResult) {
        return state.getCloneItemStack((HitResult)hitResult, (LevelReader)player.level(), hitResult.getBlockPos(), player);
    }

    public static ItemStack getEntityPickedResult(Entity entity, Player player, EntityHitResult hitResult) {
        return (ItemStack)MoreObjects.firstNonNull((Object)entity.getPickedResult((HitResult)hitResult), (Object)ItemStack.EMPTY);
    }

    public static Component getFluidName(JadeFluidObject fluid) {
        return CommonProxy.toFluidStack(fluid).getDisplayName();
    }

    public static FluidStack toFluidStack(JadeFluidObject fluid) {
        return new FluidStack(fluid.getType(), (int)fluid.getAmount(), fluid.getTag());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        List<String> classNames = ModList.get().getAllScanData().stream().flatMap($ -> $.getAnnotations().stream()).filter($ -> {
            if ($.annotationType().getClassName().equals(WailaPlugin.class.getName())) {
                String required = $.annotationData().getOrDefault("value", "");
                return required.isEmpty() || ModList.get().isLoaded(required);
            }
            return false;
        }).map(ModFileScanData.AnnotationData::memberName).toList();
        for (String className : classNames) {
            Jade.LOGGER.info("Start loading plugin at {}", (Object)className);
            try {
                Class<?> clazz = Class.forName(className);
                if (!IWailaPlugin.class.isAssignableFrom(clazz)) continue;
                IWailaPlugin plugin = (IWailaPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.register(WailaCommonRegistration.instance());
                if (!CommonProxy.isPhysicallyClient()) continue;
                plugin.registerClient(WailaClientRegistration.instance());
            }
            catch (Throwable e) {
                Jade.LOGGER.error("Error loading plugin at {}", (Object)className, (Object)e);
            }
        }
        Jade.loadComplete();
    }

    public static boolean isMultipartEntity(Entity target) {
        return target.isMultipartEntity();
    }

    public static Entity wrapPartEntityParent(Entity target) {
        if (target instanceof PartEntity) {
            PartEntity part = (PartEntity)target;
            return part.getParent();
        }
        return target;
    }

    public static int getPartEntityIndex(Entity entity) {
        if (!(entity instanceof PartEntity)) {
            return -1;
        }
        PartEntity part = (PartEntity)entity;
        Entity parent = CommonProxy.wrapPartEntityParent(entity);
        PartEntity[] parts = parent.getParts();
        if (parts == null) {
            return -1;
        }
        return List.of(parts).indexOf(part);
    }

    public static Entity getPartEntity(Entity parent, int index) {
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        PartEntity[] parts = parent.getParts();
        if (parts == null || index >= parts.length) {
            return parent;
        }
        return parts[index];
    }
}

