/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public class JadeForgeUtils {
    private JadeForgeUtils() {
    }

    public static ItemIterator<? extends IItemHandler> fromItemHandler(IItemHandler storage, int fromIndex) {
        return JadeForgeUtils.fromItemHandler(storage, fromIndex, CommonProxy::findItemHandler);
    }

    public static ItemIterator<? extends IItemHandler> fromItemHandler(IItemHandler storage, int fromIndex, Function<Accessor<?>, @Nullable IItemHandler> containerFinder) {
        return new ItemIterator.SlottedItemIterator<IItemHandler>(containerFinder, fromIndex){

            @Override
            protected int getSlotCount(IItemHandler container) {
                return container.getSlots();
            }

            @Override
            protected ItemStack getItemInSlot(IItemHandler container, int slot) {
                return container.getStackInSlot(slot);
            }
        };
    }

    public static CompoundTag fromFluidStack(FluidStack fluidStack, long capacity) {
        CompoundTag tag = new CompoundTag();
        if (capacity <= 0L) {
            return tag;
        }
        tag.putString("fluid", BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()).toString());
        tag.putLong("amount", (long)fluidStack.getAmount());
        tag.putLong("capacity", capacity);
        if (fluidStack.getTag() != null) {
            tag.put("tag", (Tag)fluidStack.getTag());
        }
        return tag;
    }

    public static List<ViewGroup<CompoundTag>> fromFluidHandler(IFluidHandler fluidHandler) {
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>(fluidHandler.getTanks());
        int emptyCapacity = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            int capacity = fluidHandler.getTankCapacity(i);
            if (capacity <= 0) continue;
            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
            if (fluidStack.isEmpty()) {
                emptyCapacity = IntMath.saturatedAdd((int)emptyCapacity, (int)capacity);
                continue;
            }
            list.add(JadeForgeUtils.fromFluidStack(fluidStack, capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0) {
            list.add(JadeForgeUtils.fromFluidStack(FluidStack.EMPTY, emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }
}

