/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.mixin.multipart_entities.client;

import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.multipart_entities.util.OrientedBox;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public class EntityRenderDispatcherMixin {
    @Inject(method={"renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;F)V"}, at={@At(value="RETURN")})
    private static void drawOrientedBoxes(PoseStack matrix, VertexConsumer vertices, Entity entity, float tickDelta, CallbackInfo ci) {
        AABB box = entity.getBoundingBox();
        if (box instanceof CompoundOrientedBox) {
            CompoundOrientedBox compoundOrientedBox = (CompoundOrientedBox)box;
            matrix.pushPose();
            matrix.translate(-entity.getX(), -entity.getY(), -entity.getZ());
            for (OrientedBox orientedBox : compoundOrientedBox) {
                matrix.pushPose();
                Vec3 center = orientedBox.getCenter();
                matrix.translate(center.x, center.y, center.z);
                matrix.mulPose(orientedBox.getRotation().toFloatQuat());
                LevelRenderer.renderLineBox((PoseStack)matrix, (VertexConsumer)vertices, (AABB)orientedBox.getExtents(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                matrix.popPose();
            }
            compoundOrientedBox.toVoxelShape().forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> LevelRenderer.renderLineBox((PoseStack)matrix, (VertexConsumer)vertices, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f));
            matrix.popPose();
        }
    }
}

