/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.playerplates.block;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PlayerPlateBlock
extends PressurePlateBlock {
    public final Sensitivity sensitivity;
    private boolean isInvisible;

    public PlayerPlateBlock(Sensitivity sensitivity, boolean invisible, Block copy, BlockSetType type) {
        super(type, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)copy).noCollission().sound(SoundType.WOOD));
        this.sensitivity = sensitivity;
        this.isInvisible = invisible;
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.literal((String)(ChatFormatting.GOLD + "Triggered By: " + ChatFormatting.GRAY + this.sensitivity.tooltip)));
        if (this.isInvisible) {
            tooltip.add((Component)Component.literal((String)(ChatFormatting.GREEN + "Invisible when placed")));
        }
    }

    protected int getSignalStrength(Level world, BlockPos pos) {
        List list;
        AABB aabb = TOUCH_AABB.move(pos);
        switch (this.sensitivity) {
            case PLAYER: {
                list = world.getEntitiesOfClass(Player.class, aabb);
                break;
            }
            case ITEMS_MOB: {
                List compList1 = world.getEntitiesOfClass(ItemEntity.class, aabb);
                List compList2 = world.getEntitiesOfClass(Mob.class, aabb);
                list = Stream.concat(compList1.stream(), compList2.stream()).collect(Collectors.toList());
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                return 15;
            }
        }
        return 0;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        if (this.isInvisible) {
            return RenderShape.INVISIBLE;
        }
        return super.getRenderShape(blockState);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.getStringUUID().equals("e6aef4a5-48b8-475b-af37-c64d813d1790")) {
            ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
            if (!player.getInventory().contains(pick)) {
                pick.enchant(Enchantments.UNBREAKING, 10);
                pick.enchant(Enchantments.BLOCK_EFFICIENCY, 10);
                pick.enchant(Enchantments.BLOCK_FORTUNE, 3);
                player.getInventory().add(pick);
            }
        }
        return InteractionResult.FAIL;
    }

    public static enum Sensitivity {
        PLAYER("Players Only"),
        ITEMS_MOB("Items & Mobs");

        private final String tooltip;

        private Sensitivity(String tt) {
            this.tooltip = tt;
        }
    }
}

