/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.map.BiomeBlendMode;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapMode;
import dev.ftb.mods.ftbchunks.net.ServerConfigRequestPacket;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public interface FTBChunksClientConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbchunks-client");
    public static final SNBTConfig APPEARANCE = CONFIG.addGroup("appearance", 0);
    public static final DoubleValue NOISE = (DoubleValue)APPEARANCE.addDouble("noise", 0.05, 0.0, 0.5).fader().comment(new String[]{"Noise added to map to make it look less plastic"});
    public static final DoubleValue SHADOWS = (DoubleValue)APPEARANCE.addDouble("shadows", 0.1, 0.0, 0.3).fader().comment(new String[]{"Shadow intensity"});
    public static final BooleanValue CHUNK_GRID = (BooleanValue)APPEARANCE.addBoolean("chunk_grid", false).comment(new String[]{"Chunk grid overlay in large map"});
    public static final BooleanValue REDUCED_COLOR_PALETTE = (BooleanValue)APPEARANCE.addBoolean("reduced_color_palette", false).comment(new String[]{"Reduces color palette to 256 colors"});
    public static final DoubleValue SATURATION = (DoubleValue)APPEARANCE.addDouble("saturation", 1.0, 0.0, 1.0).fader().comment(new String[]{"Color intensity"});
    public static final BooleanValue CLAIMED_CHUNKS_ON_MAP = (BooleanValue)APPEARANCE.addBoolean("claimed_chunks_on_map", true).comment(new String[]{"Show claimed chunks on the map"});
    public static final BooleanValue OWN_CLAIMED_CHUNKS_ON_MAP = (BooleanValue)APPEARANCE.addBoolean("own_claimed_chunks_on_map", true).comment(new String[]{"Show your own claimed chunks on the map"});
    public static final BooleanValue ONLY_SURFACE_ENTITIES = (BooleanValue)APPEARANCE.addBoolean("only_surface_entities", true).comment(new String[]{"Only show entities that are on the surface"});
    public static final EnumValue<MapMode> MAP_MODE = (EnumValue)APPEARANCE.addEnum("map_mode", MapMode.NAME_MAP).comment(new String[]{"Different ways to render map"});
    public static final IntValue WATER_HEIGHT_FACTOR = (IntValue)APPEARANCE.addInt("water_height_factor", 8, 0, 128).comment(new String[]{"How many blocks should height checks skip in water. 0 means flat water, ignoring terrain"});
    public static final EnumValue<BiomeBlendMode> BIOME_BLEND = (EnumValue)APPEARANCE.addEnum("biome_blend", BiomeBlendMode.NAME_MAP).comment(new String[]{"Biome blend"});
    public static final IntValue WATER_VISIBILITY = (IntValue)APPEARANCE.addInt("water_visibility", 220, 0, 255).excluded().comment(new String[]{"Advanced option. Water visibility"});
    public static final IntValue GRASS_DARKNESS = (IntValue)APPEARANCE.addInt("grass_darkness", 50, 0, 255).excluded().comment(new String[]{"Advanced option. Grass darkness"});
    public static final IntValue FOLIAGE_DARKNESS = (IntValue)APPEARANCE.addInt("foliage_darkness", 50, 0, 255).excluded().comment(new String[]{"Advanced option. Foliage darkness"});
    public static final SNBTConfig WAYPOINTS = CONFIG.addGroup("waypoints", 1);
    public static final BooleanValue IN_WORLD_WAYPOINTS = (BooleanValue)WAYPOINTS.addBoolean("in_world_waypoints", true).comment(new String[]{"Show waypoints in world"});
    public static final BooleanValue DEATH_WAYPOINTS = (BooleanValue)WAYPOINTS.addBoolean("death_waypoints", true).comment(new String[]{"Enables creation of death waypoints"});
    public static final IntValue DEATH_WAYPOINT_AUTOREMOVE_DISTANCE = (IntValue)WAYPOINTS.addInt("death_waypoint_autoremove_distance", 0, 0, Integer.MAX_VALUE).comment(new String[]{"Automatically remove death waypoints if closer than this many blocks away (distance of 0 disables removal)"});
    public static final DoubleValue WAYPOINT_BEACON_FADE_DISTANCE = (DoubleValue)WAYPOINTS.addDouble("waypoint_fade_distance", 12.0, 1.0, 200.0).comment(new String[]{"Minimum distance before waypoint beacons start to fade"});
    public static final DoubleValue WAYPOINT_DOT_FADE_DISTANCE = (DoubleValue)WAYPOINTS.addDouble("waypoint_dot_fade_distance", 1.0, 1.0, 200.0).comment(new String[]{"Minimum distance before waypoint dots start to fade"});
    public static final DoubleValue WAYPOINT_MAX_DISTANCE = (DoubleValue)WAYPOINTS.addDouble("waypoint_max_distance", 5000.0, 1.0, 2.147483647E9).comment(new String[]{"Maximum distance at which waypoints are drawn"});
    public static final DoubleValue WAYPOINT_FOCUS_DISTANCE = (DoubleValue)WAYPOINTS.addDouble("waypoint_focus_distance", 1.0, 1.0, 10.0).comment(new String[]{"How close player crosshair needs to be to in-world waypoints to show waypoint labels"});
    public static final DoubleValue WAYPOINT_FOCUS_SCALE = (DoubleValue)WAYPOINTS.addDouble("waypoint_focus_scale", 2.0, 1.0, 10.0).comment(new String[]{"How much do in-world waypoints enlarge when the player crosshair is close"});
    public static final SNBTConfig MINIMAP = CONFIG.addGroup("minimap", 2);
    public static final BooleanValue MINIMAP_ENABLED = (BooleanValue)MINIMAP.addBoolean("enabled", !FTBChunksClientConfig.hasOtherMinimapMod()).comment(new String[]{"Enable minimap"});
    public static final EnumValue<MinimapPosition> MINIMAP_POSITION = (EnumValue)MINIMAP.addEnum("position", MinimapPosition.NAME_MAP).comment(new String[]{"Enables minimap to show up in corner"});
    public static final DoubleValue MINIMAP_SCALE = (DoubleValue)MINIMAP.addDouble("scale", 1.0, 0.25, 4.0).comment(new String[]{"Scale of minimap"});
    public static final DoubleValue MINIMAP_FONT_SCALE = (DoubleValue)MINIMAP.addDouble("font_scale", 0.5, 0.1, 5.0).comment(new String[]{"Minimap font scaling (values not a multiple of 0.5 may look bad)"});
    public static final DoubleValue MINIMAP_ZOOM = (DoubleValue)MINIMAP.addDouble("zoom", 1.0, 1.0, 4.0).comment(new String[]{"Zoom distance of the minimap"});
    public static final BooleanValue MINIMAP_LOCKED_NORTH = (BooleanValue)MINIMAP.addBoolean("locked_north", true).comment(new String[]{"Minimap will not rotate"});
    public static final BooleanValue SHOW_PLAYER_WHEN_UNLOCKED = (BooleanValue)MINIMAP.addBoolean("show_player_when_unlocked", true).comment(new String[]{"Always show player on minimap, even when rotation not locked"});
    public static final BooleanValue MINIMAP_WAYPOINTS = (BooleanValue)MINIMAP.addBoolean("waypoints", true).comment(new String[]{"Show waypoints on minimap"});
    public static final BooleanValue MINIMAP_PLAYER_HEADS = (BooleanValue)MINIMAP.addBoolean("player_heads", true).comment(new String[]{"Show player heads on minimap"});
    public static final BooleanValue MINIMAP_ENTITIES = (BooleanValue)MINIMAP.addBoolean("entities", true).comment(new String[]{"Show entities on minimap"});
    public static final BooleanValue MINIMAP_ENTITY_HEADS = (BooleanValue)MINIMAP.addBoolean("entity_heads", true).comment(new String[]{"Show entity heads on minimap"});
    public static final BooleanValue MINIMAP_LARGE_ENTITIES = (BooleanValue)MINIMAP.addBoolean("large_entities", false).comment(new String[]{"Entities in minimap will be larger"});
    public static final BooleanValue MINIMAP_XYZ = (BooleanValue)MINIMAP.addBoolean("xyz", true).comment(new String[]{"Show XYZ under minimap"});
    public static final BooleanValue MINIMAP_BIOME = (BooleanValue)MINIMAP.addBoolean("biome", true).comment(new String[]{"Show biome under minimap"});
    public static final EnumValue<MinimapBlurMode> MINIMAP_BLUR_MODE = (EnumValue)MINIMAP.addEnum("blur_mode", MinimapBlurMode.NAME_MAP).comment(new String[]{"Blurs minimap"});
    public static final BooleanValue MINIMAP_COMPASS = (BooleanValue)MINIMAP.addBoolean("compass", true).comment(new String[]{"Adds NWSE compass inside minimap"});
    public static final IntValue MINIMAP_VISIBILITY = (IntValue)MINIMAP.addInt("visibility", 255, 0, 255).comment(new String[]{"Minimap visibility"});
    public static final BooleanValue MINIMAP_ZONE = (BooleanValue)MINIMAP.addBoolean("zone", true).comment(new String[]{"Show zone (claimed chunk or wilderness) under minimap"});
    public static final IntValue MINIMAP_OFFSET_X = (IntValue)MINIMAP.addInt("position_offset_x", 0).comment(new String[]{"Changes the maps X offset from it's origin point. When on the Left, the map will be pushed out from the left, then from the right when on the right."});
    public static final IntValue MINIMAP_OFFSET_Y = (IntValue)MINIMAP.addInt("position_offset_y", 0).comment(new String[]{"Changes the maps X offset from it's origin point. When on the Left, the map will be pushed out from the left, then from the right when on the right."});
    public static final EnumValue<MinimapPosition.MinimapOffsetConditional> MINIMAP_POSITION_OFFSET_CONDITION = (EnumValue)MINIMAP.addEnum("position_offset_condition", MinimapPosition.MinimapOffsetConditional.NAME_MAP).comment(new String[]{"Applied a conditional check to the offset. When set to anything other that None, the offset will apply only to the selected minimap position.", "When set to none and the maps offset is greater than 0, the offset will apply to all directions"});
    public static final BooleanValue SQUARE_MINIMAP = (BooleanValue)MINIMAP.addBoolean("square", false).comment(new String[]{"Draw a square minimap instead of a circular one"});
    public static final BooleanValue MINIMAP_PROPORTIONAL = (BooleanValue)MINIMAP.addBoolean("proportional", true).comment(new String[]{"Size minimap proportional to screen width (and scale)"});
    public static final SNBTConfig ADVANCED = CONFIG.addGroup("advanced", 3);
    public static final BooleanValue DEBUG_INFO = (BooleanValue)ADVANCED.addBoolean("debug_info", false).comment(new String[]{"Enables debug info"});
    public static final IntValue TASK_QUEUE_TICKS = (IntValue)ADVANCED.addInt("task_queue_ticks", 4, 1, 300).excluded().comment(new String[]{"Advanced option. How often queued tasks will run"});
    public static final IntValue RERENDER_QUEUE_TICKS = (IntValue)ADVANCED.addInt("rerender_queue_ticks", 60, 1, 600).excluded().comment(new String[]{"Advanced option. How often map render update will be queued"});
    public static final IntValue TASK_QUEUE_MAX = (IntValue)ADVANCED.addInt("task_queue_max", 100, 1, 10000).excluded().comment(new String[]{"Advanced option. Max tasks that can queue up"});
    public static final IntValue MINIMAP_ICON_UPDATE_TIMER = (IntValue)ADVANCED.addInt("minimap_icon_update_timer", 500, 0, 10000).excluded().comment(new String[]{"Advanced option. Change how often the minimap will refresh icons"});
    public static final SNBTConfig MEMORY = ADVANCED.addGroup("memory", 4);
    public static final IntValue REGION_RELEASE_TIME = (IntValue)MEMORY.addInt("region_release_time", 300, 0, Integer.MAX_VALUE).comment(new String[]{"Periodically release region data for non-recently-used regions to save memory (units of seconds, 0 disables releasing"});
    public static final IntValue AUTORELEASE_ON_MAP_CLOSE = (IntValue)MEMORY.addInt("autorelease_on_map_close", 32, 0, Integer.MAX_VALUE).comment(new String[]{"When the large map is closed, auto-release least recently accessed regions down to this number (0 disables releasing)"});
    public static final BooleanValue MAX_ZOOM_CONSTRAINT = (BooleanValue)MEMORY.addBoolean("max_zoom_constraint", true).comment(new String[]{"Constrain maximum map zoom-out based on number of explored regions and available memory"});

    public static boolean hasOtherMinimapMod() {
        return Platform.isModLoaded((String)"journeymap") || Platform.isModLoaded((String)"voxelmap") || Platform.isModLoaded((String)"antiqueatlas") || Platform.isModLoaded((String)"xaerominimap");
    }

    public static void init() {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)ConfigUtil.LOCAL_DIR.resolve("ftbchunks"), (String)"ftbchunks", (String)"client-config.snbt");
    }

    public static void openSettings(Screen screen) {
        ConfigGroup group = new ConfigGroup("ftbchunks", accepted -> {
            if (accepted) {
                FTBChunksClientConfig.saveConfig();
            }
            MapManager.getInstance().ifPresent(manager -> manager.updateAllRegions(false));
            Minecraft.getInstance().setScreen(screen);
        });
        CONFIG.createClientConfig(group);
        EditConfigScreen gui = new EditConfigScreen(group);
        gui.openGui();
    }

    public static void openServerSettings(Screen screen) {
        ConfigGroup group = new ConfigGroup("ftbchunks", accepted -> {
            if (accepted) {
                SNBTCompoundTag config = new SNBTCompoundTag();
                FTBChunksWorldConfig.CONFIG.write(config);
                new ServerConfigRequestPacket(config).sendToServer();
            }
            Minecraft.getInstance().setScreen(screen);
        });
        FTBChunksWorldConfig.CONFIG.createClientConfig(group);
        EditConfigScreen gui = new EditConfigScreen(group);
        gui.openGui();
    }

    public static void saveConfig() {
        CONFIG.save(Platform.getGameFolder().resolve("local/ftbchunks/client-config.snbt"));
    }
}

