/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class WaypointEditorScreen
extends BaseScreen {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba((int)-1724697805);
    private static final Icon PEARL_ICON = ImageIcon.getIcon((ResourceLocation)new ResourceLocation("minecraft", "textures/item/ender_pearl.png"));
    public static final Theme THEME = new Theme(){

        public void drawScrollBarBackground(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(graphics, x, y, w, h);
        }

        public void drawScrollBar(GuiGraphics graphics, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(graphics, x, y, w, h);
        }
    };
    private static final Component TITLE = Component.translatable((String)"ftbchunks.gui.waypoints").withStyle(ChatFormatting.BOLD);
    private final Panel waypointPanel = new WaypointPanel((Panel)this);
    private final PanelScrollBar scrollbar = new PanelScrollBar((Panel)this, this.waypointPanel){

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            if (this.getMaxValue() > (double)this.parent.height) {
                super.drawBackground(graphics, theme, x, y, w, h);
            }
        }
    };
    private final List<Widget> rows = new ArrayList<Widget>();
    private final Button buttonCollapseAll = new ExpanderButton((Panel)this, false);
    private final Button buttonExpandAll = new ExpanderButton((Panel)this, true);
    private int maxWidth;

    public WaypointEditorScreen() {
        for (DimWayPoints entry : this.collectWaypoints()) {
            this.rows.add((Widget)new VerticalSpaceWidget(this.waypointPanel, 4));
            boolean thisDimension = Minecraft.getInstance().level.dimension().location().equals((Object)entry.levelKey);
            GroupButton groupButton = new GroupButton(this.waypointPanel, (Component)Component.literal((String)entry.levelKey.toString()).withStyle(ChatFormatting.YELLOW), !thisDimension);
            this.rows.add((Widget)groupButton);
            for (WaypointImpl wp : entry.waypoints) {
                this.rows.add((Widget)new RowPanel(this.waypointPanel, groupButton, wp));
            }
        }
    }

    private List<DimWayPoints> collectWaypoints() {
        ArrayList<DimWayPoints> res = new ArrayList<DimWayPoints>();
        Player player = (Player)Objects.requireNonNull(Minecraft.getInstance().player);
        MapManager manager = MapManager.getInstance().orElseThrow();
        manager.getDimensions().values().stream().filter(dim -> !dim.getWaypointManager().isEmpty()).sorted((dim1, dim2) -> {
            ResourceLocation dim1id = dim1.dimension.location();
            ResourceLocation dim2id = dim2.dimension.location();
            if (dim1id.getNamespace().equals("minecraft") && !dim2id.getNamespace().equals("minecraft")) {
                return -1;
            }
            int i = dim1id.getNamespace().compareTo(dim2id.getNamespace());
            return i == 0 ? dim1id.getPath().compareTo(dim2id.getPath()) : i;
        }).forEach(dim -> res.add(new DimWayPoints(dim.dimension.location(), dim.getWaypointManager().stream().sorted(Comparator.comparingDouble(wp -> wp.getDistanceSq((Entity)player))).toList())));
        return res;
    }

    public boolean onInit() {
        boolean r = this.setFullscreen();
        this.maxWidth = Math.min(this.maxWidth, this.getGui().width / 2);
        return r;
    }

    public void addWidgets() {
        this.add((Widget)this.waypointPanel);
        this.add((Widget)this.scrollbar);
        this.add((Widget)this.buttonCollapseAll);
        this.add((Widget)this.buttonExpandAll);
    }

    public void alignWidgets() {
        this.waypointPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.waypointPanel.alignWidgets();
        this.scrollbar.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonExpandAll.setPos(this.width - 18, 2);
        this.buttonCollapseAll.setPos(this.width - 38, 2);
    }

    public Theme getTheme() {
        return super.getTheme();
    }

    public Component getTitle() {
        return TITLE;
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(graphics, 0, 0, w, 20);
        theme.drawString(graphics, (Object)this.getTitle(), 6, 6, 2);
    }

    public boolean keyPressed(Key key) {
        if (key.esc() && this.getContextMenu().isPresent()) {
            this.closeContextMenu();
            return true;
        }
        return super.keyPressed(key);
    }

    private class WaypointPanel
    extends Panel {
        public WaypointPanel(Panel panel) {
            super(panel);
        }

        public void addWidgets() {
            WaypointEditorScreen.this.maxWidth = 0;
            for (Widget row : WaypointEditorScreen.this.rows) {
                if (row instanceof RowPanel) {
                    RowPanel rowPanel = (RowPanel)row;
                    if (rowPanel.groupButton.collapsed || rowPanel.deleted) continue;
                }
                this.add(row);
                if (!(row instanceof RowPanel)) continue;
                RowPanel rp = (RowPanel)row;
                WaypointEditorScreen.this.maxWidth = Math.max(WaypointEditorScreen.this.maxWidth, WaypointEditorScreen.this.getTheme().getStringWidth(rp.wp.getName()));
            }
            WaypointEditorScreen.this.maxWidth = Math.min(WaypointEditorScreen.this.maxWidth, this.getGui().width / 2);
        }

        public void alignWidgets() {
            this.align(WidgetLayout.VERTICAL);
            int sbWidth = WaypointEditorScreen.this.scrollbar.getMaxValue() > 0.0 ? 16 : 0;
            WaypointEditorScreen.this.scrollbar.setWidth(sbWidth);
            this.widgets.forEach(w -> {
                int prevWidth = w.width;
                w.setWidth(this.width - sbWidth);
                if (w.width != prevWidth && w instanceof Panel) {
                    Panel p = (Panel)w;
                    p.alignWidgets();
                }
            });
        }
    }

    private class ExpanderButton
    extends SimpleButton {
        public ExpanderButton(Panel panel, boolean expand) {
            super(panel, (Component)Component.translatable((String)(expand ? "gui.expand_all" : "gui.collapse_all")), expand ? Icons.DOWN : Icons.UP, (btn, mb) -> {
                dev$ftb$mods$ftbchunks$client$gui$WaypointEditorScreen$this.rows.stream().filter(w -> w instanceof GroupButton).map(w -> (GroupButton)((Object)((Object)w))).forEach(g -> g.setCollapsed(!expand));
                dev$ftb$mods$ftbchunks$client$gui$WaypointEditorScreen$this.scrollbar.setValue(0.0);
                btn.getGui().refreshWidgets();
            });
        }
    }

    private record DimWayPoints(ResourceLocation levelKey, List<WaypointImpl> waypoints) {
    }

    private static class GroupButton
    extends Button {
        private boolean collapsed;
        private final Component titleText;

        public GroupButton(Panel panel, Component titleText, boolean startCollapsed) {
            super(panel);
            this.titleText = titleText;
            this.setCollapsed(startCollapsed);
        }

        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }

        void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            this.setTitle((Component)Component.literal((String)(collapsed ? "[>] " : "[v] ")).withStyle(collapsed ? ChatFormatting.RED : ChatFormatting.GREEN).append(this.titleText));
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(graphics, x, y, w, h);
            theme.drawString(graphics, (Object)this.getTitle(), x + 3, y + 1 + (h - theme.getFontHeight()) / 2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color4I.GRAY.withAlpha(80).draw(graphics, 0, y, this.width, 1);
            Color4I.GRAY.withAlpha(80).draw(graphics, 0, y, 1, this.height);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        public void addMouseOverText(TooltipList list) {
        }
    }

    private class RowPanel
    extends Panel {
        private final GroupButton groupButton;
        private final WaypointImpl wp;
        private boolean deleted;

        public RowPanel(Panel panel, GroupButton groupButton, WaypointImpl wp) {
            super(panel);
            this.deleted = false;
            this.groupButton = groupButton;
            this.wp = wp;
            this.setHeight(18);
        }

        public void addWidgets() {
            this.add((Widget)new SimpleButton((Panel)this, (Component)Component.empty(), this.wp.isHidden() ? Icons.REMOVE_GRAY : Icons.ACCEPT, (w, mb) -> {
                this.wp.setHidden(!this.wp.isHidden());
                w.setIcon(this.wp.isHidden() ? Icons.REMOVE_GRAY : Icons.ACCEPT);
            }));
            this.add((Widget)new TextField((Panel)this).setMaxWidth(WaypointEditorScreen.this.maxWidth).setTrim().setText(this.wp.getName()).setColor(Color4I.rgb((int)this.wp.getColor())).addFlags(2));
            LocalPlayer player = Minecraft.getInstance().player;
            String distStr = player.level().dimension().equals(this.wp.getDimension()) ? String.format("%.1fm", Math.sqrt(this.wp.getDistanceSq((Entity)player))) : "";
            this.add((Widget)new TextField((Panel)this).setText(distStr).setColor(Color4I.GRAY));
        }

        public void alignWidgets() {
            if (this.widgets.size() == 3) {
                int yOff = (this.height - WaypointEditorScreen.this.getTheme().getFontHeight()) / 2 + 1;
                ((Widget)this.widgets.get(0)).setPos(10, 1);
                ((Widget)this.widgets.get(1)).setPos(30, yOff);
                ((Widget)this.widgets.get(2)).setPos(WaypointEditorScreen.this.maxWidth + 40, yOff);
            }
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            super.draw(graphics, theme, x, y, w, h);
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && button.isRight()) {
                ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
                list.add(this.makeTitleMenuItem());
                list.add(ContextMenuItem.SEPARATOR);
                list.add(new ContextMenuItem((Component)Component.translatable((String)"gui.rename"), Icons.CHAT, btn -> {
                    StringConfig config = new StringConfig();
                    config.setDefaultValue((Object)"");
                    config.setValue((Object)this.wp.getName());
                    config.onClicked((Widget)btn, MouseButton.LEFT, accepted -> {
                        if (accepted) {
                            this.wp.setName((String)config.getValue());
                        }
                        this.openGui();
                    });
                }));
                if (this.wp.getType().canChangeColor()) {
                    list.add(new ContextMenuItem((Component)Component.translatable((String)"ftbchunks.gui.change_color"), Icons.COLOR_RGB, btn -> {
                        ColorConfig col = new ColorConfig();
                        col.setValue((Object)Color4I.rgb((int)this.wp.getColor()));
                        ColorSelectorPanel.popupAtMouse((BaseScreen)btn.getGui(), (ColorConfig)col, accepted -> {
                            if (accepted) {
                                this.wp.setColor(((Color4I)col.getValue()).rgba());
                                this.wp.refreshIcon();
                                Object patt11927$temp = this.widgets.get(1);
                                if (patt11927$temp instanceof TextField) {
                                    TextField tf = (TextField)patt11927$temp;
                                    tf.setColor(Color4I.rgb((int)this.wp.getColor()));
                                }
                            }
                        });
                    }));
                }
                if (Minecraft.getInstance().player.hasPermissions(2)) {
                    list.add(new ContextMenuItem((Component)Component.translatable((String)"ftbchunks.gui.teleport"), PEARL_ICON, btn -> {
                        BlockPos pos = this.wp.getPos().above();
                        new TeleportFromMapPacket(pos, false, this.wp.getDimension()).sendToServer();
                        this.closeGui(false);
                    }));
                }
                list.add(new ContextMenuItem((Component)Component.translatable((String)"gui.remove"), Icons.REMOVE, btn -> this.getGui().openYesNo((Component)Component.translatable((String)"ftbchunks.gui.delete_waypoint", (Object[])new Object[]{Component.literal((String)this.wp.getName()).withStyle(Style.EMPTY.withColor(this.wp.getColor()))}), (Component)Component.empty(), () -> {
                    this.wp.removeFromManager();
                    this.deleted = true;
                    this.getGui().refreshWidgets();
                })));
                this.getGui().openContextMenu(list);
                return true;
            }
            return super.mousePressed(button);
        }

        private ContextMenuItem makeTitleMenuItem() {
            return new ContextMenuItem((Component)Component.literal((String)this.wp.getName()), (Icon)Icon.empty(), null){

                public Icon getIcon() {
                    return RowPanel.this.wp.getType().getIcon().withTint(Color4I.rgb((int)RowPanel.this.wp.getColor()));
                }
            };
        }
    }
}

